/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.runtime;

import com.hazelcast.com.google.common.base.Preconditions;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.runtime.Automaton;
import com.hazelcast.org.apache.calcite.runtime.AutomatonBuilder;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;

public interface Pattern {
    default public Automaton toAutomaton() {
        return new AutomatonBuilder().add(this).build();
    }

    public static PatternBuilder builder() {
        return new PatternBuilder();
    }

    public static class RepeatPattern
    extends OpPattern {
        final int minRepeat;
        final int maxRepeat;

        RepeatPattern(int minRepeat, int maxRepeat, Pattern pattern) {
            super(Op.REPEAT, pattern);
            this.minRepeat = minRepeat;
            this.maxRepeat = maxRepeat;
        }

        @Override
        public String toString() {
            return "(" + this.patterns.get(0) + "){" + this.minRepeat + (this.maxRepeat == this.minRepeat ? "" : ", " + this.maxRepeat) + "}";
        }
    }

    public static class OpPattern
    extends AbstractPattern {
        final ImmutableList<Pattern> patterns;

        OpPattern(Op op, Pattern ... patterns) {
            super(op);
            Preconditions.checkArgument(patterns.length >= op.minArity);
            Preconditions.checkArgument(op.maxArity == -1 || patterns.length <= op.maxArity);
            this.patterns = ImmutableList.copyOf(patterns);
        }

        public String toString() {
            switch (this.op) {
                case SEQ: {
                    return this.patterns.stream().map(Object::toString).collect(Collectors.joining(" "));
                }
                case STAR: {
                    return "(" + this.patterns.get(0) + ")*";
                }
                case PLUS: {
                    return "(" + this.patterns.get(0) + ")+";
                }
                case OR: {
                    return this.patterns.get(0) + "|" + this.patterns.get(1);
                }
                case OPTIONAL: {
                    return this.patterns.get(0) + "?";
                }
            }
            throw new AssertionError((Object)("unknown op " + (Object)((Object)this.op)));
        }
    }

    public static class SymbolPattern
    extends AbstractPattern {
        final String name;

        SymbolPattern(String name) {
            super(Op.SYMBOL);
            this.name = Objects.requireNonNull(name);
        }

        public String toString() {
            return this.name;
        }
    }

    public static abstract class AbstractPattern
    implements Pattern {
        final Op op;

        AbstractPattern(Op op) {
            this.op = Objects.requireNonNull(op);
        }

        @Override
        public Automaton toAutomaton() {
            return new AutomatonBuilder().add(this).build();
        }
    }

    public static class PatternBuilder {
        final Stack<Pattern> stack = new Stack();

        private PatternBuilder() {
        }

        private PatternBuilder push(Pattern item) {
            this.stack.push(item);
            return this;
        }

        public Pattern build() {
            if (this.stack.size() != 1) {
                throw new AssertionError((Object)("expected stack to have one item, but was " + this.stack));
            }
            return this.stack.pop();
        }

        public Automaton automaton() {
            return new AutomatonBuilder().add(this.build()).build();
        }

        public PatternBuilder symbol(String symbolName) {
            return this.push(new SymbolPattern(symbolName));
        }

        public PatternBuilder seq() {
            Pattern pattern1 = this.stack.pop();
            Pattern pattern0 = this.stack.pop();
            return this.push(new OpPattern(Op.SEQ, pattern0, pattern1));
        }

        public PatternBuilder star() {
            return this.push(new OpPattern(Op.STAR, this.stack.pop()));
        }

        public PatternBuilder plus() {
            return this.push(new OpPattern(Op.PLUS, this.stack.pop()));
        }

        public PatternBuilder or() {
            if (this.stack.size() < 2) {
                throw new AssertionError((Object)("Expecting stack to have at least 2 items, but has " + this.stack.size()));
            }
            Pattern pattern1 = this.stack.pop();
            Pattern pattern0 = this.stack.pop();
            return this.push(new OpPattern(Op.OR, pattern0, pattern1));
        }

        public PatternBuilder repeat(int minRepeat, int maxRepeat) {
            Pattern pattern = this.stack.pop();
            return this.push(new RepeatPattern(minRepeat, maxRepeat, pattern));
        }

        public PatternBuilder optional() {
            Pattern pattern = this.stack.pop();
            return this.push(new OpPattern(Op.OPTIONAL, pattern));
        }
    }

    public static enum Op {
        SYMBOL(0, 0),
        ANCHOR_START(0, 0),
        ANCHOR_END(0, 0),
        SEQ(2, -1),
        OR(2, -1),
        STAR(1, 1),
        PLUS(1, 1),
        REPEAT(1, 1),
        OPTIONAL(1, 1);

        private final int minArity;
        private final int maxArity;

        private Op(int minArity, int maxArity) {
            this.minArity = minArity;
            this.maxArity = maxArity;
        }
    }
}

