/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.sql.dialect.CalciteSqlDialect;

public abstract class SqlSampleSpec {
    protected SqlSampleSpec() {
    }

    public static SqlSampleSpec createNamed(String name) {
        return new SqlSubstitutionSampleSpec(name);
    }

    public static SqlSampleSpec createTableSample(boolean isBernoulli, float samplePercentage) {
        return new SqlTableSampleSpec(isBernoulli, samplePercentage);
    }

    public static SqlSampleSpec createTableSample(boolean isBernoulli, float samplePercentage, int repeatableSeed) {
        return new SqlTableSampleSpec(isBernoulli, samplePercentage, repeatableSeed);
    }

    public static class SqlTableSampleSpec
    extends SqlSampleSpec {
        private final boolean isBernoulli;
        private final float samplePercentage;
        private final boolean isRepeatable;
        private final int repeatableSeed;

        private SqlTableSampleSpec(boolean isBernoulli, float samplePercentage) {
            this.isBernoulli = isBernoulli;
            this.samplePercentage = samplePercentage;
            this.isRepeatable = false;
            this.repeatableSeed = 0;
        }

        private SqlTableSampleSpec(boolean isBernoulli, float samplePercentage, int repeatableSeed) {
            this.isBernoulli = isBernoulli;
            this.samplePercentage = samplePercentage;
            this.isRepeatable = true;
            this.repeatableSeed = repeatableSeed;
        }

        public boolean isBernoulli() {
            return this.isBernoulli;
        }

        public float getSamplePercentage() {
            return this.samplePercentage;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public int getRepeatableSeed() {
            return this.repeatableSeed;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.isBernoulli ? "BERNOULLI" : "SYSTEM");
            b.append('(');
            b.append((double)this.samplePercentage * 100.0);
            b.append(')');
            if (this.isRepeatable) {
                b.append(" REPEATABLE(");
                b.append(this.repeatableSeed);
                b.append(')');
            }
            return b.toString();
        }
    }

    public static class SqlSubstitutionSampleSpec
    extends SqlSampleSpec {
        private final String name;

        private SqlSubstitutionSampleSpec(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "SUBSTITUTE(" + CalciteSqlDialect.DEFAULT.quoteStringLiteral(this.name) + ")";
        }
    }
}

