/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.security.IdentityConfig;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.security.ICredentialsFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class CredentialsFactoryConfig
implements IdentityConfig {
    private volatile String className;
    private volatile ICredentialsFactory implementation;
    private volatile Properties properties = new Properties();

    public CredentialsFactoryConfig() {
    }

    public CredentialsFactoryConfig(String className) {
        this.className = className;
    }

    private CredentialsFactoryConfig(CredentialsFactoryConfig credentialsFactoryConfig) {
        this.className = credentialsFactoryConfig.className;
        this.implementation = credentialsFactoryConfig.implementation;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)credentialsFactoryConfig.properties);
    }

    public String getClassName() {
        return this.className;
    }

    public CredentialsFactoryConfig setClassName(String className) {
        this.className = className;
        return this;
    }

    public ICredentialsFactory getImplementation() {
        return this.implementation;
    }

    public CredentialsFactoryConfig setImplementation(ICredentialsFactory factoryImpl) {
        this.implementation = factoryImpl;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public CredentialsFactoryConfig setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public ICredentialsFactory asCredentialsFactory(ClassLoader cl) {
        if (this.implementation == null) {
            try {
                this.implementation = (ICredentialsFactory)ClassLoaderUtil.newInstance(cl, this.className);
                this.implementation.init(this.properties);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not create instance of '" + this.className + "', cause: " + e.getMessage(), e);
            }
        }
        return this.implementation;
    }

    @Override
    public IdentityConfig copy() {
        return new CredentialsFactoryConfig(this);
    }

    public String toString() {
        return "CredentialsFactoryConfig{className='" + this.className + '\'' + ", implementation=" + this.implementation + ", properties=" + this.properties + '}';
    }

    public int hashCode() {
        return Objects.hash(this.className, this.implementation, this.properties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CredentialsFactoryConfig other = (CredentialsFactoryConfig)obj;
        return Objects.equals(this.className, other.className) && Objects.equals(this.implementation, other.implementation) && Objects.equals(this.properties, other.properties);
    }
}

