/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.MutationObserver;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nonnull;

class CompositeMutationObserver<R extends Record>
implements MutationObserver<R> {
    private Collection<MutationObserver<R>> mutationObservers;

    CompositeMutationObserver() {
    }

    void add(MutationObserver<R> mutationObserver) {
        if (this.mutationObservers == null) {
            this.mutationObservers = new LinkedList<MutationObserver<R>>();
        }
        this.mutationObservers.add(mutationObserver);
    }

    @Override
    public void onClear() {
        if (CollectionUtil.isEmpty(this.mutationObservers)) {
            return;
        }
        for (MutationObserver<R> mutationObserver : this.mutationObservers) {
            mutationObserver.onClear();
        }
    }

    @Override
    public void onPutRecord(Data key, R record, Object oldValue, boolean backup) {
        if (CollectionUtil.isEmpty(this.mutationObservers)) {
            return;
        }
        for (MutationObserver<R> mutationObserver : this.mutationObservers) {
            mutationObserver.onPutRecord(key, record, oldValue, backup);
        }
    }

    @Override
    public void onReplicationPutRecord(@Nonnull Data key, @Nonnull R record, boolean populateIndex) {
        if (CollectionUtil.isEmpty(this.mutationObservers)) {
            return;
        }
        for (MutationObserver<R> mutationObserver : this.mutationObservers) {
            mutationObserver.onReplicationPutRecord(key, record, populateIndex);
        }
    }

    @Override
    public void onUpdateRecord(@Nonnull Data key, @Nonnull R record, Object oldValue, Object newValue, boolean backup) {
        if (CollectionUtil.isEmpty(this.mutationObservers)) {
            return;
        }
        Throwable exception = null;
        for (MutationObserver<R> mutationObserver : this.mutationObservers) {
            try {
                mutationObserver.onUpdateRecord(key, record, oldValue, newValue, backup);
            }
            catch (Throwable t) {
                if (exception != null) continue;
                exception = t;
            }
        }
        if (exception != null) {
            ExceptionUtil.rethrow(exception);
        }
    }

    @Override
    public void onRemoveRecord(Data key, R record, boolean backup) {
        if (CollectionUtil.isEmpty(this.mutationObservers)) {
            return;
        }
        for (MutationObserver<R> mutationObserver : this.mutationObservers) {
            mutationObserver.onRemoveRecord(key, record, backup);
        }
    }

    @Override
    public void onEvictRecord(Data key, R record, boolean backup) {
        if (CollectionUtil.isEmpty(this.mutationObservers)) {
            return;
        }
        for (MutationObserver<R> mutationObserver : this.mutationObservers) {
            mutationObserver.onEvictRecord(key, record, backup);
        }
    }

    @Override
    public void onLoadRecord(@Nonnull Data key, @Nonnull R record, boolean backup) {
        if (CollectionUtil.isEmpty(this.mutationObservers)) {
            return;
        }
        for (MutationObserver<R> mutationObserver : this.mutationObservers) {
            mutationObserver.onLoadRecord(key, record, backup);
        }
    }

    @Override
    public void onDestroy(boolean isDuringShutdown, boolean internal) {
        if (CollectionUtil.isEmpty(this.mutationObservers)) {
            return;
        }
        for (MutationObserver<R> mutationObserver : this.mutationObservers) {
            mutationObserver.onDestroy(isDuringShutdown, internal);
        }
    }

    @Override
    public void onReset() {
        if (CollectionUtil.isEmpty(this.mutationObservers)) {
            return;
        }
        for (MutationObserver<R> mutationObserver : this.mutationObservers) {
            mutationObserver.onReset();
        }
    }
}

