/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.avatica.remote;

import com.hazelcast.org.apache.calcite.avatica.remote.AuthenticationType;
import com.hazelcast.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import com.hazelcast.org.apache.calcite.avatica.remote.GSSAuthenticateable;
import com.hazelcast.org.apache.calcite.avatica.remote.HttpClientPoolConfigurable;
import com.hazelcast.org.apache.calcite.avatica.remote.UsernamePasswordAuthenticateable;
import com.hazelcast.org.apache.hc.client5.http.ClientProtocolException;
import com.hazelcast.org.apache.hc.client5.http.SystemDefaultDnsResolver;
import com.hazelcast.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import com.hazelcast.org.apache.hc.client5.http.auth.AuthScope;
import com.hazelcast.org.apache.hc.client5.http.auth.Credentials;
import com.hazelcast.org.apache.hc.client5.http.auth.CredentialsProvider;
import com.hazelcast.org.apache.hc.client5.http.auth.KerberosConfig;
import com.hazelcast.org.apache.hc.client5.http.auth.KerberosCredentials;
import com.hazelcast.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import com.hazelcast.org.apache.hc.client5.http.classic.methods.HttpPost;
import com.hazelcast.org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import com.hazelcast.org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import com.hazelcast.org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import com.hazelcast.org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import com.hazelcast.org.apache.hc.client5.http.impl.auth.SPNegoSchemeFactory;
import com.hazelcast.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.hazelcast.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.hazelcast.org.apache.hc.client5.http.impl.classic.HttpClients;
import com.hazelcast.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import com.hazelcast.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.hazelcast.org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import com.hazelcast.org.apache.hc.core5.http.ClassicHttpRequest;
import com.hazelcast.org.apache.hc.core5.http.ContentType;
import com.hazelcast.org.apache.hc.core5.http.NoHttpResponseException;
import com.hazelcast.org.apache.hc.core5.http.config.Lookup;
import com.hazelcast.org.apache.hc.core5.http.config.Registry;
import com.hazelcast.org.apache.hc.core5.http.config.RegistryBuilder;
import com.hazelcast.org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import com.hazelcast.org.apache.hc.core5.http.io.entity.EntityUtils;
import com.hazelcast.org.slf4j.Logger;
import com.hazelcast.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Principal;
import java.util.Objects;
import org.ietf.jgss.GSSCredential;

public class AvaticaCommonsHttpClientImpl
implements AvaticaHttpClient,
HttpClientPoolConfigurable,
UsernamePasswordAuthenticateable,
GSSAuthenticateable {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaCommonsHttpClientImpl.class);
    private static final boolean USE_CANONICAL_HOSTNAME = Boolean.parseBoolean(System.getProperty("avatica.http.spnego.use_canonical_hostname", "true"));
    private static final boolean STRIP_PORT_ON_SERVER_LOOKUP = true;
    private static final KerberosConfig KERBEROS_CONFIG = KerberosConfig.custom().setStripPort(true).setUseCanonicalHostname(USE_CANONICAL_HOSTNAME).build();
    private static AuthScope anyAuthScope = new AuthScope(null, -1);
    protected final URI uri;
    protected BasicAuthCache authCache;
    protected CloseableHttpClient client;
    protected Registry<ConnectionSocketFactory> socketFactoryRegistry;
    protected PoolingHttpClientConnectionManager pool;
    protected UsernamePasswordCredentials credentials = null;
    protected CredentialsProvider credentialsProvider = null;
    protected Lookup<AuthSchemeFactory> authRegistry = null;
    protected Object userToken;

    public AvaticaCommonsHttpClientImpl(URL url) {
        this.uri = AvaticaCommonsHttpClientImpl.toURI(Objects.requireNonNull(url));
    }

    protected void initializeClient(PoolingHttpClientConnectionManager pool) {
        this.authCache = new BasicAuthCache();
        this.client = HttpClients.custom().setConnectionManager(pool).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] send(byte[] request) {
        while (true) {
            HttpClientContext context = HttpClientContext.create();
            if (null != this.credentialsProvider) {
                context.setCredentialsProvider(this.credentialsProvider);
                context.setAuthSchemeRegistry(this.authRegistry);
                context.setAuthCache(this.authCache);
            }
            if (null != this.userToken) {
                context.setUserToken(this.userToken);
            }
            ByteArrayEntity entity = new ByteArrayEntity(request, ContentType.APPLICATION_OCTET_STREAM);
            HttpPost post = new HttpPost(this.uri);
            post.setEntity(entity);
            try {
                CloseableHttpResponse response = this.execute(post, context);
                try {
                    int statusCode = response.getCode();
                    if (200 == statusCode || 500 == statusCode) {
                        this.userToken = context.getUserToken();
                        byte[] byArray = EntityUtils.toByteArray(response.getEntity());
                        return byArray;
                    }
                    if (503 != statusCode) throw new RuntimeException("Failed to execute HTTP Request, got HTTP/" + statusCode);
                    LOG.debug("Failed to connect to server (HTTP/503), retrying");
                    continue;
                }
                finally {
                    if (response == null) continue;
                    response.close();
                    continue;
                }
            }
            catch (NoHttpResponseException e) {
                LOG.debug("The server failed to issue an HTTP response, retrying");
                continue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.debug("Failed to execute HTTP request", e);
                throw new RuntimeException(e);
            }
            break;
        }
    }

    CloseableHttpResponse execute(HttpPost post, HttpClientContext context) throws IOException, ClientProtocolException {
        return this.client.execute((ClassicHttpRequest)post, context);
    }

    @Override
    public void setUsernamePassword(AuthenticationType authType, String username, String password) {
        this.credentials = new UsernamePasswordCredentials(Objects.requireNonNull(username), Objects.requireNonNull(password).toCharArray());
        this.credentialsProvider = new BasicCredentialsProvider();
        ((BasicCredentialsProvider)this.credentialsProvider).setCredentials(anyAuthScope, this.credentials);
        RegistryBuilder<AuthSchemeFactory> authRegistryBuilder = RegistryBuilder.create();
        switch (authType) {
            case BASIC: {
                authRegistryBuilder.register("Basic", new BasicSchemeFactory());
                break;
            }
            case DIGEST: {
                authRegistryBuilder.register("Digest", new DigestSchemeFactory());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authentiation type: " + (Object)((Object)authType));
            }
        }
        this.authRegistry = authRegistryBuilder.build();
    }

    @Override
    public void setGSSCredential(GSSCredential credential) {
        this.authRegistry = RegistryBuilder.create().register("Negotiate", new SPNegoSchemeFactory(KERBEROS_CONFIG, SystemDefaultDnsResolver.INSTANCE)).build();
        this.credentialsProvider = new BasicCredentialsProvider();
        if (null != credential) {
            ((BasicCredentialsProvider)this.credentialsProvider).setCredentials(anyAuthScope, new KerberosCredentials(credential));
        } else {
            ((BasicCredentialsProvider)this.credentialsProvider).setCredentials(anyAuthScope, EmptyCredentials.INSTANCE);
        }
    }

    private static URI toURI(URL url) throws RuntimeException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setHttpClientPool(PoolingHttpClientConnectionManager pool) {
        this.initializeClient(pool);
    }

    private static class EmptyCredentials
    implements Credentials {
        public static final EmptyCredentials INSTANCE = new EmptyCredentials();

        private EmptyCredentials() {
        }

        @Override
        public char[] getPassword() {
            return null;
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }
    }
}

