/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.metadata;

import com.hazelcast.com.google.common.collect.HashMultimap;
import com.hazelcast.com.google.common.collect.ImmutableSet;
import com.hazelcast.org.apache.calcite.plan.hep.HepRelVertex;
import com.hazelcast.org.apache.calcite.plan.volcano.RelSubset;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.core.Calc;
import com.hazelcast.org.apache.calcite.rel.core.Exchange;
import com.hazelcast.org.apache.calcite.rel.core.Filter;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.core.Sample;
import com.hazelcast.org.apache.calcite.rel.core.SetOp;
import com.hazelcast.org.apache.calcite.rel.core.Sort;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.core.Window;
import com.hazelcast.org.apache.calcite.rel.metadata.BuiltInMetadata;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rex.RexTableInputRef;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RelMdTableReferences
implements MetadataHandler<BuiltInMetadata.TableReferences> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.TABLE_REFERENCES.method, new RelMdTableReferences());

    protected RelMdTableReferences() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.TableReferences> getDef() {
        return BuiltInMetadata.TableReferences.DEF;
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(RelNode rel, RelMetadataQuery mq) {
        return null;
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(HepRelVertex rel, RelMetadataQuery mq) {
        return mq.getTableReferences(rel.getCurrentRel());
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(RelSubset rel, RelMetadataQuery mq) {
        return mq.getTableReferences(Util.first(rel.getBest(), rel.getOriginal()));
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(TableScan rel, RelMetadataQuery mq) {
        return ImmutableSet.of(RexTableInputRef.RelTableRef.of(rel.getTable(), 0));
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(Aggregate rel, RelMetadataQuery mq) {
        return mq.getTableReferences(rel.getInput());
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(Join rel, RelMetadataQuery mq) {
        RelNode leftInput = rel.getLeft();
        RelNode rightInput = rel.getRight();
        HashSet<RexTableInputRef.RelTableRef> result = new HashSet<RexTableInputRef.RelTableRef>();
        HashMultimap<List<String>, RexTableInputRef.RelTableRef> leftQualifiedNamesToRefs = HashMultimap.create();
        Set<RexTableInputRef.RelTableRef> leftTableRefs = mq.getTableReferences(leftInput);
        if (leftTableRefs == null) {
            return null;
        }
        for (RexTableInputRef.RelTableRef leftRef : leftTableRefs) {
            assert (!result.contains(leftRef));
            result.add(leftRef);
            leftQualifiedNamesToRefs.put(leftRef.getQualifiedName(), leftRef);
        }
        Set<RexTableInputRef.RelTableRef> rightTableRefs = mq.getTableReferences(rightInput);
        if (rightTableRefs == null) {
            return null;
        }
        for (RexTableInputRef.RelTableRef rightRef : rightTableRefs) {
            int shift = 0;
            Collection lRefs = leftQualifiedNamesToRefs.get(rightRef.getQualifiedName());
            if (lRefs != null) {
                shift = lRefs.size();
            }
            RexTableInputRef.RelTableRef shiftTableRef = RexTableInputRef.RelTableRef.of(rightRef.getTable(), shift + rightRef.getEntityNumber());
            assert (!result.contains(shiftTableRef));
            result.add(shiftTableRef);
        }
        return result;
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(SetOp rel, RelMetadataQuery mq) {
        HashSet<RexTableInputRef.RelTableRef> result = new HashSet<RexTableInputRef.RelTableRef>();
        HashMultimap<List<String>, RexTableInputRef.RelTableRef> qualifiedNamesToRefs = HashMultimap.create();
        for (RelNode input : rel.getInputs()) {
            HashMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> currentTablesMapping = new HashMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>();
            Set<RexTableInputRef.RelTableRef> inputTableRefs = mq.getTableReferences(input);
            if (inputTableRefs == null) {
                return null;
            }
            for (RexTableInputRef.RelTableRef tableRef : inputTableRefs) {
                int shift = 0;
                Collection lRefs = qualifiedNamesToRefs.get(tableRef.getQualifiedName());
                if (lRefs != null) {
                    shift = lRefs.size();
                }
                RexTableInputRef.RelTableRef shiftTableRef = RexTableInputRef.RelTableRef.of(tableRef.getTable(), shift + tableRef.getEntityNumber());
                assert (!result.contains(shiftTableRef));
                result.add(shiftTableRef);
                currentTablesMapping.put(tableRef, shiftTableRef);
            }
            for (RexTableInputRef.RelTableRef newRef : currentTablesMapping.values()) {
                qualifiedNamesToRefs.put(newRef.getQualifiedName(), newRef);
            }
        }
        return result;
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(Project rel, RelMetadataQuery mq) {
        return mq.getTableReferences(rel.getInput());
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(Filter rel, RelMetadataQuery mq) {
        return mq.getTableReferences(rel.getInput());
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(Calc rel, RelMetadataQuery mq) {
        return mq.getTableReferences(rel.getInput());
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(Sort rel, RelMetadataQuery mq) {
        return mq.getTableReferences(rel.getInput());
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(TableModify rel, RelMetadataQuery mq) {
        return mq.getTableReferences(rel.getInput());
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(Exchange rel, RelMetadataQuery mq) {
        return mq.getTableReferences(rel.getInput());
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(Window rel, RelMetadataQuery mq) {
        return mq.getTableReferences(rel.getInput());
    }

    public Set<RexTableInputRef.RelTableRef> getTableReferences(Sample rel, RelMetadataQuery mq) {
        return mq.getTableReferences(rel.getInput());
    }
}

