/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.statistic;

import com.hazelcast.com.google.common.cache.Cache;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.util.concurrent.UncheckedExecutionException;
import com.hazelcast.org.apache.calcite.materialize.SqlStatisticProvider;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.util.ImmutableIntList;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class CachingSqlStatisticProvider
implements SqlStatisticProvider {
    private final SqlStatisticProvider provider;
    private final Cache<List, Object> cache;

    public CachingSqlStatisticProvider(SqlStatisticProvider provider, Cache<List, Object> cache) {
        this.provider = provider;
        this.cache = cache;
    }

    @Override
    public double tableCardinality(RelOptTable table) {
        try {
            ImmutableList<List<String>> key = ImmutableList.of("tableCardinality", table.getQualifiedName());
            return (Double)this.cache.get(key, () -> this.provider.tableCardinality(table));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Util.throwIfUnchecked(e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public boolean isForeignKey(RelOptTable fromTable, List<Integer> fromColumns, RelOptTable toTable, List<Integer> toColumns) {
        try {
            ImmutableList<ImmutableIntList> key = ImmutableList.of("isForeignKey", fromTable.getQualifiedName(), ImmutableIntList.copyOf(fromColumns), toTable.getQualifiedName(), ImmutableIntList.copyOf(toColumns));
            return (Boolean)this.cache.get(key, () -> this.provider.isForeignKey(fromTable, fromColumns, toTable, toColumns));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Util.throwIfUnchecked(e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public boolean isKey(RelOptTable table, List<Integer> columns) {
        try {
            ImmutableList<ImmutableIntList> key = ImmutableList.of("isKey", table.getQualifiedName(), ImmutableIntList.copyOf(columns));
            return (Boolean)this.cache.get(key, () -> this.provider.isKey(table, columns));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Util.throwIfUnchecked(e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }
}

