/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security;

import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.TokenCredentials;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

@BinaryInterface
@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class SimpleTokenCredentials
implements TokenCredentials,
IdentifiedDataSerializable {
    private static final long serialVersionUID = -1508314631354255039L;
    private byte[] token;

    public SimpleTokenCredentials() {
    }

    public SimpleTokenCredentials(byte[] token) {
        Objects.requireNonNull(token, "Token has to be provided.");
        this.token = token;
    }

    @Override
    public byte[] getToken() {
        return this.token != null ? Arrays.copyOf(this.token, this.token.length) : null;
    }

    @Override
    public String getName() {
        return this.token == null ? "<empty>" : "<token>";
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByteArray(this.token);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.token = in.readByteArray();
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 24;
    }

    public String toString() {
        return "SimpleTokenCredentials [tokenLength=" + (this.token != null ? this.token.length : 0) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.token);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTokenCredentials other = (SimpleTokenCredentials)obj;
        return Arrays.equals(this.token, other.token);
    }
}

