/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.sort;

import com.hazelcast.sql.impl.exec.fetch.Fetch;
import com.hazelcast.sql.impl.exec.sort.MergeSortSource;
import com.hazelcast.sql.impl.exec.sort.SortKey;
import com.hazelcast.sql.impl.exec.sort.SortKeyComparator;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="This is an internal class")
public class MergeSort {
    private final MergeSortSource[] sources;
    private final PriorityQueue<SortKey> heap;
    private long fetchValue;
    private long offsetValue;
    private final Set<Integer> missingSourceIndexes = new HashSet<Integer>();
    private final Expression<?> fetch;
    private final Expression<?> offset;
    private long returnedCount;
    private int offsetApplied;
    private boolean done;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is an internal class")
    public MergeSort(MergeSortSource[] sources, SortKeyComparator comparator, Expression<?> fetch, Expression<?> offset) {
        this.sources = sources;
        this.heap = new PriorityQueue<SortKey>(comparator);
        this.fetch = fetch;
        this.offset = offset;
        for (int i = 0; i < sources.length; ++i) {
            this.missingSourceIndexes.add(i);
        }
    }

    public void setup(ExpressionEvalContext context) {
        this.fetchValue = Fetch.getFetchValue(context, this.fetch);
        this.offsetValue = Fetch.getOffsetValue(context, this.offset);
    }

    public List<Row> nextBatch() {
        if (this.done) {
            return null;
        }
        if (!this.prepare()) {
            return null;
        }
        return this.fetch();
    }

    private boolean prepare() {
        if (this.missingSourceIndexes.isEmpty()) {
            return true;
        }
        Iterator<Integer> iter = this.missingSourceIndexes.iterator();
        while (iter.hasNext()) {
            Integer index = iter.next();
            MergeSortSource source = this.sources[index];
            if (source.advance()) {
                SortKey key = source.peekKey();
                assert (key != null);
                this.heap.add(key);
                iter.remove();
                continue;
            }
            if (source.isDone()) {
                iter.remove();
                continue;
            }
            return false;
        }
        return true;
    }

    private List<Row> fetch() {
        int sourceIndex;
        assert (this.missingSourceIndexes.isEmpty());
        ArrayList<Row> rows = new ArrayList<Row>();
        while (true) {
            if (this.heap.isEmpty() || this.returnedCount == this.fetchValue) {
                this.done = true;
                return rows;
            }
            SortKey key = this.heap.poll();
            assert (key != null);
            sourceIndex = (int)key.getIndex();
            MergeSortSource source = this.sources[sourceIndex];
            Row row = source.peekRow();
            assert (row != null);
            if ((long)this.offsetApplied >= this.offsetValue) {
                rows.add(row);
                ++this.returnedCount;
            } else {
                ++this.offsetApplied;
            }
            if (source.advance()) {
                SortKey nextKey = source.peekKey();
                this.heap.add(nextKey);
                continue;
            }
            if (!source.isDone()) break;
        }
        this.missingSourceIndexes.add(sourceIndex);
        return rows;
    }

    public boolean isDone() {
        return this.done;
    }

    public MergeSortSource[] getSources() {
        return this.sources;
    }
}

