/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.core.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class HazelcastCache
implements Cache {
    private static final DataSerializable NULL = new NullDataSerializable();
    private final IMap<Object, Object> map;

    public HazelcastCache(IMap<Object, Object> map) {
        this.map = map;
    }

    public String getName() {
        return this.map.getName();
    }

    public Object getNativeCache() {
        return this.map;
    }

    public Cache.ValueWrapper get(Object key) {
        if (key == null) {
            return null;
        }
        Object value = this.lookup(key);
        return value != null ? new SimpleValueWrapper(this.fromStoreValue(value)) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.fromStoreValue(this.lookup(key));
        if (type != null && value != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value = this.lookup(key);
        if (value != null) {
            return (T)this.fromStoreValue(value);
        }
        this.map.lock(key);
        try {
            value = this.lookup(key);
            if (value != null) {
                Object object = this.fromStoreValue(value);
                return (T)object;
            }
            T t = this.loadValue(key, valueLoader);
            return t;
        }
        finally {
            this.map.unlock(key);
        }
    }

    private <T> T loadValue(Object key, Callable<T> valueLoader) {
        T value;
        try {
            value = valueLoader.call();
        }
        catch (Exception ex) {
            throw ValueRetrievalExceptionResolver.resolveException(key, valueLoader, ex);
        }
        this.put(key, value);
        return value;
    }

    public void put(Object key, Object value) {
        if (key != null) {
            this.map.set(key, this.toStoreValue(value));
        }
    }

    protected Object toStoreValue(Object value) {
        if (value == null) {
            return NULL;
        }
        return value;
    }

    protected Object fromStoreValue(Object value) {
        if (NULL.equals(value)) {
            return null;
        }
        return value;
    }

    public void evict(Object key) {
        if (key != null) {
            this.map.delete(key);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object result = this.map.putIfAbsent(key, this.toStoreValue(value));
        return result != null ? new SimpleValueWrapper(this.fromStoreValue(result)) : null;
    }

    private Object lookup(Object key) {
        return this.map.get(key);
    }

    private static class ValueRetrievalExceptionResolver {
        private ValueRetrievalExceptionResolver() {
        }

        static RuntimeException resolveException(Object key, Callable<?> valueLoader, Throwable ex) {
            return new Cache.ValueRetrievalException(key, valueLoader, ex);
        }
    }

    static final class NullDataSerializable
    implements DataSerializable {
        NullDataSerializable() {
        }

        public void writeData(ObjectDataOutput out) throws IOException {
        }

        public void readData(ObjectDataInput in) throws IOException {
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return 0;
        }
    }
}

