/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.util.EmptyStatement;
import com.hazelcast.web.LocalCacheEntry;
import com.hazelcast.web.WebFilter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class HazelcastHttpSession
implements HttpSession {
    volatile String invalidatedOriginalSessionId;
    private WebFilter webFilter;
    private volatile boolean valid = true;
    private final String id;
    private final HttpSession originalSession;
    private final Map<String, LocalCacheEntry> localCache = new ConcurrentHashMap<String, LocalCacheEntry>();
    private final boolean stickySession;
    private final boolean deferredWrite;
    private volatile boolean clusterWideNew;
    private Set<String> transientAttributes;

    public HazelcastHttpSession(WebFilter webFilter, String sessionId, HttpSession originalSession, boolean deferredWrite, boolean stickySession) {
        this.webFilter = webFilter;
        this.id = sessionId;
        this.originalSession = originalSession;
        this.deferredWrite = deferredWrite;
        this.stickySession = stickySession;
        String transientAttributesParam = webFilter.getParam("transient-attributes");
        if (transientAttributesParam == null) {
            this.transientAttributes = Collections.emptySet();
        } else {
            this.transientAttributes = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(transientAttributesParam, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.transientAttributes.add(token.trim());
            }
        }
        this.buildLocalCache();
    }

    public HttpSession getOriginalSession() {
        return this.originalSession;
    }

    public String getOriginalSessionId() {
        return this.originalSession != null ? this.originalSession.getId() : null;
    }

    public void setAttribute(String name, Object value) {
        LocalCacheEntry entry;
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        boolean transientEntry = false;
        if (this.transientAttributes.contains(name)) {
            transientEntry = true;
        }
        if ((entry = this.localCache.get(name)) == null || entry == WebFilter.NULL_ENTRY) {
            entry = new LocalCacheEntry(transientEntry);
            this.localCache.put(name, entry);
        }
        entry.setValue(value);
        entry.setDirty(true);
        entry.setRemoved(false);
        entry.setReload(false);
        if (!this.deferredWrite && !transientEntry) {
            try {
                this.webFilter.getClusteredSessionService().setAttribute(this.id, name, value);
                entry.setDirty(false);
            }
            catch (Exception ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
        }
    }

    public Object getAttribute(String name) {
        LocalCacheEntry cacheEntry;
        block5: {
            cacheEntry = this.localCache.get(name);
            Object value = null;
            if (cacheEntry == null || cacheEntry.isReload()) {
                try {
                    value = this.webFilter.getClusteredSessionService().getAttribute(this.id, name);
                    cacheEntry = new LocalCacheEntry(false, value);
                    cacheEntry.setReload(false);
                    this.localCache.put(name, cacheEntry);
                }
                catch (Exception e) {
                    if (WebFilter.LOGGER.isFinestEnabled()) {
                        WebFilter.LOGGER.finest("session could not be load so you might be dealing with stale data", (Throwable)e);
                    }
                    if (cacheEntry != null) break block5;
                    return null;
                }
            }
        }
        if (cacheEntry.isRemoved()) {
            return null;
        }
        return cacheEntry.getValue();
    }

    public Enumeration<String> getAttributeNames() {
        final Set<String> keys = this.selectKeys();
        return new Enumeration<String>(){
            private final String[] elements;
            private int index;
            {
                this.elements = keys.toArray(new String[keys.size()]);
            }

            @Override
            public boolean hasMoreElements() {
                return this.index < this.elements.length;
            }

            @Override
            public String nextElement() {
                return this.elements[this.index++];
            }
        };
    }

    public String getId() {
        return this.id;
    }

    public ServletContext getServletContext() {
        return this.webFilter.servletContext;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return this.originalSession.getSessionContext();
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        Set<String> keys = this.selectKeys();
        return keys.toArray(new String[keys.size()]);
    }

    public void invalidate() {
        this.webFilter.destroySession(this, true);
        this.originalSession.invalidate();
        this.invalidatedOriginalSessionId = this.originalSession.getId();
    }

    public boolean isNew() {
        return this.originalSession.isNew() && this.clusterWideNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        LocalCacheEntry entry = this.localCache.get(name);
        if (entry != null && entry != WebFilter.NULL_ENTRY) {
            entry.setValue(null);
            entry.setRemoved(true);
            entry.setDirty(true);
            entry.setReload(false);
        }
        if (!this.deferredWrite) {
            try {
                this.webFilter.getClusteredSessionService().deleteAttribute(this.id, name);
            }
            catch (Exception ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public boolean sessionChanged() {
        for (Map.Entry<String, LocalCacheEntry> entry : this.localCache.entrySet()) {
            if (!entry.getValue().isDirty()) continue;
            return true;
        }
        return false;
    }

    public long getCreationTime() {
        return this.originalSession.getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.originalSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.originalSession.getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int maxInactiveSeconds) {
        this.originalSession.setMaxInactiveInterval(maxInactiveSeconds);
    }

    void destroy(boolean invalidate) {
        this.valid = false;
        this.webFilter.getClusteredSessionService().deleteSession(this.id, invalidate);
    }

    public boolean isValid() {
        return this.valid;
    }

    private void buildLocalCache() {
        Set<Map.Entry<String, Object>> entrySet = null;
        try {
            entrySet = this.webFilter.getClusteredSessionService().getAttributes(this.id);
        }
        catch (Exception e) {
            return;
        }
        if (entrySet != null) {
            for (Map.Entry<String, Object> entry : entrySet) {
                String attributeKey = entry.getKey();
                LocalCacheEntry cacheEntry = this.localCache.get(attributeKey);
                if (cacheEntry == null) {
                    cacheEntry = new LocalCacheEntry(this.transientAttributes.contains(attributeKey));
                    this.localCache.put(attributeKey, cacheEntry);
                }
                if (WebFilter.LOGGER.isFinestEnabled()) {
                    WebFilter.LOGGER.finest("Storing " + attributeKey + " on session " + this.id);
                }
                cacheEntry.setValue(entry.getValue());
                cacheEntry.setDirty(false);
            }
        }
    }

    void sessionDeferredWrite() {
        if (this.sessionChanged() || this.isNew()) {
            HashMap<String, Object> updates = new HashMap<String, Object>();
            for (Map.Entry<String, LocalCacheEntry> entry : this.localCache.entrySet()) {
                LocalCacheEntry cacheEntry = entry.getValue();
                if (!cacheEntry.isDirty() || cacheEntry.isTransient()) continue;
                if (cacheEntry.isRemoved()) {
                    updates.put(entry.getKey(), null);
                } else {
                    updates.put(entry.getKey(), cacheEntry.getValue());
                }
                cacheEntry.setDirty(false);
            }
            try {
                this.webFilter.getClusteredSessionService().updateAttributes(this.id, updates);
            }
            catch (Exception ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
        }
    }

    private Set<String> selectKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (!this.deferredWrite) {
            Set<String> attributeNames = null;
            try {
                attributeNames = this.webFilter.getClusteredSessionService().getAttributeNames(this.id);
            }
            catch (Exception ignored) {
                for (Map.Entry<String, LocalCacheEntry> entry : this.localCache.entrySet()) {
                    if (entry.getValue().isRemoved() || entry.getValue().getValue() == null) continue;
                    keys.add(entry.getKey());
                }
            }
            if (attributeNames != null) {
                keys.addAll(attributeNames);
            }
        } else {
            for (Map.Entry<String, LocalCacheEntry> entry : this.localCache.entrySet()) {
                if (entry.getValue().isRemoved() || entry.getValue().getValue() == null) continue;
                keys.add(entry.getKey());
            }
        }
        return keys;
    }

    public void setClusterWideNew(boolean clusterWideNew) {
        this.clusterWideNew = clusterWideNew;
    }

    public boolean isStickySession() {
        return this.stickySession;
    }

    public void updateReloadFlag() {
        for (Map.Entry<String, LocalCacheEntry> entry : this.localCache.entrySet()) {
            if (entry.getValue().isDirty()) continue;
            entry.getValue().setReload(true);
        }
    }
}

