/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.receiver.net;

import com.helger.as2lib.processor.receiver.net.INetModuleHandler;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.http.HTTPHelper;
import com.helger.commons.annotation.Nonempty;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractReceiverHandler
implements INetModuleHandler {
    private Consumer<X509Certificate> m_aVerificationCertificateConsumer;
    private IHTTPIncomingDumper m_aHttpIncomingDumper;

    @Nullable
    public final Consumer<X509Certificate> getVerificationCertificateConsumer() {
        return this.m_aVerificationCertificateConsumer;
    }

    @Nonnull
    public final AbstractReceiverHandler setVerificationCertificateConsumer(@Nullable Consumer<X509Certificate> consumer) {
        this.m_aVerificationCertificateConsumer = consumer;
        return this;
    }

    @Nullable
    public final IHTTPIncomingDumper getHttpIncomingDumper() {
        return this.m_aHttpIncomingDumper;
    }

    @Nullable
    public final IHTTPIncomingDumper getEffectiveHttpIncomingDumper() {
        IHTTPIncomingDumper iHTTPIncomingDumper = this.m_aHttpIncomingDumper;
        if (iHTTPIncomingDumper == null) {
            iHTTPIncomingDumper = HTTPHelper.getHTTPIncomingDumper();
        }
        return iHTTPIncomingDumper;
    }

    public final void setHttpIncomingDumper(@Nullable IHTTPIncomingDumper iHTTPIncomingDumper) {
        this.m_aHttpIncomingDumper = iHTTPIncomingDumper;
    }

    @Nonnull
    @Nonempty
    public String getClientInfo(@Nonnull Socket socket) {
        return socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
    }
}

