/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.sender;

import com.helger.as2lib.disposition.DispositionType;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.message.IMessageMDN;
import com.helger.as2lib.processor.AS2NoModuleException;
import com.helger.as2lib.processor.sender.AS2HttpResponseException;
import com.helger.as2lib.processor.sender.AbstractHttpSenderModule;
import com.helger.as2lib.session.AS2ComponentNotFoundException;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.AS2ResourceHelper;
import com.helger.as2lib.util.CAS2Header;
import com.helger.as2lib.util.dump.IHTTPOutgoingDumper;
import com.helger.as2lib.util.http.AS2HttpClient;
import com.helger.as2lib.util.http.AS2HttpHeaderSetter;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.timing.StopWatch;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchMDNSenderModule
extends AbstractHttpSenderModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsynchMDNSenderModule.class);

    @Override
    public boolean canHandle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) {
        return string.equals("sendmdn") && iMessage instanceof AS2Message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendViaHTTP(@Nonnull AS2Message aS2Message, @Nonnull DispositionType dispositionType, @Nullable IHTTPOutgoingDumper iHTTPOutgoingDumper, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws AS2Exception, IOException, MessagingException {
        IMessageMDN iMessageMDN = aS2Message.getMDN();
        String string = aS2Message.getAsyncMDNurl();
        EHttpMethod eHttpMethod = EHttpMethod.POST;
        AS2HttpClient aS2HttpClient = this.getHttpClient(string, eHttpMethod, this.getSession().getHttpProxy());
        try {
            if (iHTTPOutgoingDumper != null) {
                iHTTPOutgoingDumper.start(string, aS2Message);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Connecting to " + string + aS2Message.getLoggingText());
            }
            HttpHeaderMap httpHeaderMap = iMessageMDN.headers().getClone();
            httpHeaderMap.setHeader("Connection", "close, TE");
            httpHeaderMap.setHeader("User-Agent", CAS2Header.DEFAULT_USER_AGENT);
            boolean bl = this.isQuoteHeaderValues();
            AS2HttpHeaderSetter aS2HttpHeaderSetter = new AS2HttpHeaderSetter(aS2HttpClient, iHTTPOutgoingDumper, bl);
            httpHeaderMap.forEachSingleHeader(aS2HttpHeaderSetter::setHttpHeader, true, false);
            if (iHTTPOutgoingDumper != null) {
                iHTTPOutgoingDumper.finishedHeaders();
            }
            aS2Message.attrs().putIn((Object)"destination_ip", (Object)aS2HttpClient.getURL().getHost());
            aS2Message.attrs().putIn("destination_port", aS2HttpClient.getURL().getPort());
            InputStream inputStream = iMessageMDN.getData().getInputStream();
            StopWatch stopWatch = StopWatch.createdStarted();
            long l = aS2HttpClient.send(inputStream, null, iHTTPOutgoingDumper, aS2ResourceHelper);
            stopWatch.stop();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("AS2 MDN transferred " + AS2IOHelper.getTransferRate(l, stopWatch) + aS2Message.getLoggingText());
            }
            if (iHTTPOutgoingDumper != null) {
                iHTTPOutgoingDumper.finishedPayload();
            }
            int n = aS2HttpClient.getResponseCode();
            if (this.getOutgoingHttpCallback() != null) {
                this.getOutgoingHttpCallback().onOutgoingHttpMessage(false, aS2Message.getAS2From(), aS2Message.getAS2To(), aS2Message.getMessageID(), null, null, string, n);
            }
            if (AS2HttpClient.isErrorResponseCode(n)) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("sent AsyncMDN [" + dispositionType.getAsString() + "] Fail(" + n + ") " + aS2Message.getLoggingText());
                }
                throw new AS2HttpResponseException(string, n, aS2HttpClient.getResponseMessage());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("sent AsyncMDN [" + dispositionType.getAsString() + "] OK(" + n + ") " + aS2Message.getLoggingText());
            }
            try {
                this.getSession().getMessageProcessor().handle("storemdn", aS2Message, null);
            }
            catch (AS2NoModuleException | AS2ComponentNotFoundException aS2Exception) {
                // empty catch block
            }
        }
        finally {
            aS2HttpClient.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) throws AS2Exception {
        try (AS2ResourceHelper aS2ResourceHelper = new AS2ResourceHelper();){
            AS2Message aS2Message = (AS2Message)iMessage;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Async MDN submitted" + aS2Message.getLoggingText());
            }
            DispositionType dispositionType = DispositionType.createSuccess();
            int n = this.getRetryCount(aS2Message.partnership(), map);
            try (IHTTPOutgoingDumper iHTTPOutgoingDumper = this.getHttpOutgoingDumper(aS2Message);){
                this._sendViaHTTP(aS2Message, dispositionType, iHTTPOutgoingDumper, aS2ResourceHelper);
            }
            catch (AS2HttpResponseException aS2HttpResponseException) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Http Response Error " + aS2HttpResponseException.getMessage());
                }
                aS2HttpResponseException.terminate();
                if (!this.doResend("sendmdn", aS2Message, aS2HttpResponseException, n)) {
                    throw aS2HttpResponseException;
                }
            }
            catch (IOException iOException) {
                AS2Exception aS2Exception = WrappedAS2Exception.wrap(iOException).setSourceMsg(aS2Message).terminate();
                if (!this.doResend("sendmdn", aS2Message, aS2Exception, n)) {
                    throw aS2Exception;
                }
            }
            catch (Exception exception) {
                throw WrappedAS2Exception.wrap(exception);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Async MDN message sent");
            }
        }
    }
}

