/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib;

import com.helger.as2lib.IDynamicComponent;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.session.IAS2Session;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractDynamicComponent
implements IDynamicComponent {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final StringMap m_aAttrs = new StringMap();
    private IAS2Session m_aSession;

    @Nonnull
    @ReturnsMutableObject
    public final StringMap attrs() {
        return this.m_aAttrs;
    }

    @Override
    @Nonnull
    public String getName() {
        return ClassHelper.getClassLocalName((Object)this);
    }

    @Nonnull
    public final String getAttributeAsStringRequired(@Nonnull String string) throws AS2InvalidParameterException {
        String string2 = this.attrs().getAsString((Object)string);
        if (string2 == null) {
            throw new AS2InvalidParameterException("Parameter not found", this, string, null);
        }
        return string2;
    }

    public final int getAttributeAsIntRequired(@Nonnull String string) throws AS2InvalidParameterException {
        int n = this.attrs().getAsInt((Object)string, Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            throw new AS2InvalidParameterException("Parameter not found", this, string, null);
        }
        return n;
    }

    @Override
    @Nonnull
    public final IAS2Session getSession() {
        if (this.m_aSession == null) {
            throw new IllegalStateException("No AS2 session present so far!");
        }
        return this.m_aSession;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void initDynamicComponent(@Nonnull IAS2Session iAS2Session, @Nullable IStringMap iStringMap) throws AS2Exception {
        this.m_aSession = (IAS2Session)ValueEnforcer.notNull((Object)iAS2Session, (String)"Session");
        this.attrs().putAllIn((Map)iStringMap);
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).getToString();
    }
}

