/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.crypto;

import com.helger.as2lib.crypto.ICryptoAlgorithm;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSAlgorithm;

public enum ECryptoAlgorithmCrypt implements ICryptoAlgorithm
{
    CRYPT_3DES("3des", PKCSObjectIdentifiers.des_EDE3_CBC),
    CRYPT_CAST5("cast5", CMSAlgorithm.CAST5_CBC),
    CRYPT_IDEA("idea", CMSAlgorithm.IDEA_CBC),
    CRYPT_RC2("rc2", PKCSObjectIdentifiers.RC2_CBC),
    CRYPT_AES128_CBC("aes128-cbc", CMSAlgorithm.AES128_CBC),
    CRYPT_AES192_CBC("aes192-cbc", CMSAlgorithm.AES192_CBC),
    CRYPT_AES256_CBC("aes256-cbc", CMSAlgorithm.AES256_CBC),
    CRYPT_AES128_GCM("aes128-gcm", CMSAlgorithm.AES128_GCM),
    CRYPT_AES192_GCM("aes192-gcm", CMSAlgorithm.AES192_GCM),
    CRYPT_AES256_GCM("aes256-gcm", CMSAlgorithm.AES256_GCM);

    private final String m_sID;
    private final ASN1ObjectIdentifier m_aOID;

    private ECryptoAlgorithmCrypt(String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.m_sID = string2;
        this.m_aOID = aSN1ObjectIdentifier;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    public ASN1ObjectIdentifier getOID() {
        return this.m_aOID;
    }

    @Nullable
    public static ECryptoAlgorithmCrypt getFromIDOrNull(@Nullable String string) {
        return (ECryptoAlgorithmCrypt)EnumHelper.getFromIDCaseInsensitiveOrNull(ECryptoAlgorithmCrypt.class, (String)string);
    }

    @Nonnull
    public static ECryptoAlgorithmCrypt getFromIDOrThrow(@Nullable String string) {
        return (ECryptoAlgorithmCrypt)EnumHelper.getFromIDCaseInsensitiveOrThrow(ECryptoAlgorithmCrypt.class, (String)string);
    }

    @Nullable
    public static ECryptoAlgorithmCrypt getFromIDOrDefault(@Nullable String string, @Nullable ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt) {
        return (ECryptoAlgorithmCrypt)EnumHelper.getFromIDCaseInsensitiveOrDefault(ECryptoAlgorithmCrypt.class, (String)string, (Enum)eCryptoAlgorithmCrypt);
    }
}

