/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.crypto;

import com.helger.commons.collection.ArrayHelper;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LoggingMessageDigest
extends MessageDigest {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingMessageDigest.class);
    private final MessageDigest m_aMD;

    LoggingMessageDigest(@Nonnull MessageDigest messageDigest) {
        super(messageDigest.getAlgorithm());
        this.m_aMD = messageDigest;
    }

    @Override
    protected void engineUpdate(byte by) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("update(1): " + by);
        }
        this.m_aMD.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("update(" + n2 + "): " + Arrays.toString(ArrayHelper.getCopy((byte[])byArray, (int)n, (int)n2)));
        }
        this.m_aMD.update(byArray, n, n2);
    }

    @Override
    protected byte[] engineDigest() {
        byte[] byArray = this.m_aMD.digest();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("digest=" + Arrays.toString(byArray));
        }
        return byArray;
    }

    @Override
    protected void engineReset() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("reset");
        }
        this.m_aMD.reset();
    }
}

