/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.crypto;

import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.base64.Base64;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MIC
implements Serializable {
    private final byte[] m_aMICBytes;
    private final ECryptoAlgorithmSign m_eDigestAlgorithm;

    public MIC(@Nonnull byte[] byArray, @Nonnull ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        ValueEnforcer.notNull((Object)byArray, (String)"MICBytes");
        ValueEnforcer.notNull((Object)eCryptoAlgorithmSign, (String)"DigestAlgorithm");
        this.m_aMICBytes = byArray;
        this.m_eDigestAlgorithm = eCryptoAlgorithmSign;
    }

    @Nonnull
    public byte[] micBytes() {
        return this.m_aMICBytes;
    }

    @Nonnull
    public ECryptoAlgorithmSign getDigestAlgorithm() {
        return this.m_eDigestAlgorithm;
    }

    @Nonnull
    @Nonempty
    public String getAsAS2String() {
        return Base64.encodeBytes((byte[])this.m_aMICBytes) + ", " + this.m_eDigestAlgorithm.getID();
    }

    @Nonnull
    private static ECryptoAlgorithmSign _getUnified(@Nonnull ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        switch (eCryptoAlgorithmSign) {
            case DIGEST_RSA_MD5: {
                return ECryptoAlgorithmSign.DIGEST_MD5;
            }
            case DIGEST_RSA_SHA1: 
            case DIGEST_SHA1: {
                return ECryptoAlgorithmSign.DIGEST_SHA_1;
            }
            case DIGEST_SHA256: {
                return ECryptoAlgorithmSign.DIGEST_SHA_256;
            }
            case DIGEST_SHA384: {
                return ECryptoAlgorithmSign.DIGEST_SHA_384;
            }
            case DIGEST_SHA512: {
                return ECryptoAlgorithmSign.DIGEST_SHA_512;
            }
        }
        return eCryptoAlgorithmSign;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MIC mIC = (MIC)object;
        return Arrays.equals(this.m_aMICBytes, mIC.m_aMICBytes) && MIC._getUnified(this.m_eDigestAlgorithm).equals(MIC._getUnified(mIC.m_eDigestAlgorithm));
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMICBytes).append((Enum)this.m_eDigestAlgorithm).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("MICBytes", this.m_aMICBytes).append("DigestAlgorithm", (Enum)this.m_eDigestAlgorithm).getToString();
    }

    @Nullable
    public static MIC parse(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\r\n");
        String string2 = stringTokenizer.nextToken();
        byte[] byArray = Base64.safeDecode((String)string2);
        if (byArray == null) {
            throw new IllegalArgumentException("Failed to base64 decode '" + string2 + "'");
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("Separator after Base64 bytes is missing");
        }
        String string3 = stringTokenizer.nextToken();
        ECryptoAlgorithmSign eCryptoAlgorithmSign = ECryptoAlgorithmSign.getFromIDOrNull(string3);
        if (eCryptoAlgorithmSign == null) {
            throw new IllegalArgumentException("Failed to parse digest algorithm '" + string3 + "'");
        }
        return new MIC(byArray, eCryptoAlgorithmSign);
    }
}

