/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.exception;

import com.helger.as2lib.CAS2Info;
import com.helger.as2lib.message.IMessage;
import com.helger.commons.lang.ClassHelper;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2Exception
extends Exception {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2Exception.class);
    private IMessage m_aSrcMsg;
    private File m_aSrcFile;

    public AS2Exception() {
        this.log(false);
    }

    public AS2Exception(@Nullable String string) {
        super(string);
    }

    public AS2Exception(@Nullable String string, @Nullable Throwable throwable) {
        super(string, throwable);
    }

    public AS2Exception(@Nullable Throwable throwable) {
        super(throwable);
    }

    @Nullable
    public final IMessage getSourceMsg() {
        return this.m_aSrcMsg;
    }

    @Nonnull
    public final AS2Exception setSourceMsg(@Nullable IMessage iMessage) {
        this.m_aSrcMsg = iMessage;
        return this;
    }

    @Nullable
    public final File getSourceFile() {
        return this.m_aSrcFile;
    }

    @Nonnull
    public final AS2Exception setSourceFile(@Nullable File file) {
        this.m_aSrcFile = file;
        return this;
    }

    @Nonnull
    public final AS2Exception terminate() {
        this.log(true);
        return this;
    }

    protected final void log(boolean bl) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(CAS2Info.NAME_VERSION + " " + ClassHelper.getClassLocalName(this.getClass()) + " " + (bl ? "terminated" : "caught") + ": " + this.getMessage() + (this.m_aSrcFile == null ? "" : "; source file: " + this.m_aSrcFile.getAbsolutePath()) + (this.m_aSrcMsg == null ? "" : "; source msg: " + this.m_aSrcMsg.getLoggingText()), this.getCause());
        }
    }
}

