/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.params;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.commons.annotation.Nonempty;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS2InvalidParameterException
extends AS2Exception {
    private final Serializable m_aTarget;
    private final String m_sKey;
    private final String m_sValue;

    public AS2InvalidParameterException(@Nullable String string, @Nullable Serializable serializable, @Nullable String string2, @Nullable String string3) {
        super(string + " - " + AS2InvalidParameterException.getAsString(string2, string3));
        this.m_aTarget = serializable;
        this.m_sKey = string2;
        this.m_sValue = string3;
    }

    public AS2InvalidParameterException(@Nullable String string) {
        super(string);
        this.m_aTarget = null;
        this.m_sKey = null;
        this.m_sValue = null;
    }

    @Nullable
    public String getKey() {
        return this.m_sKey;
    }

    @Nullable
    public Serializable getTarget() {
        return this.m_aTarget;
    }

    @Nullable
    public String getValue() {
        return this.m_sValue;
    }

    public static void checkValue(@Nonnull Serializable serializable, @Nonnull String string, @Nullable Object object) throws AS2InvalidParameterException {
        if (object == null) {
            throw new AS2InvalidParameterException("Value is missing", serializable, string, null);
        }
    }

    @Nonnull
    @Nonempty
    public static String getAsString(@Nullable String string, @Nullable String string2) {
        return "Invalid parameter value for " + string + ": " + string2;
    }
}

