/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.partner;

import com.helger.as2lib.AbstractDynamicComponent;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.message.IMessageMDN;
import com.helger.as2lib.params.MessageParameters;
import com.helger.as2lib.partner.AS2PartnershipNotFoundException;
import com.helger.as2lib.partner.IPartnershipFactory;
import com.helger.as2lib.partner.IPartnershipMap;
import com.helger.as2lib.partner.Partnership;
import com.helger.as2lib.partner.PartnershipMap;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.IsLocked;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.functional.IThrowingSupplier;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractPartnershipFactory
extends AbstractDynamicComponent
implements IPartnershipFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPartnershipFactory.class);
    private final PartnershipMap m_aPartnerships = new PartnershipMap();

    @OverrideOnDemand
    @IsLocked(value=ELockType.WRITE)
    protected void markAsChanged() throws AS2Exception {
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public Partnership getPartnership(@Nonnull Partnership partnership) throws AS2Exception {
        ValueEnforcer.notNull((Object)partnership, (String)"Partnership");
        return (Partnership)this.m_aRWLock.readLockedGetThrowing((IThrowingSupplier & Serializable)() -> {
            Partnership partnership2 = this.m_aPartnerships.getPartnershipByName(partnership.getName());
            if (partnership2 == null) {
                partnership2 = this.m_aPartnerships.getPartnershipByID(partnership.getAllSenderIDs(), partnership.getAllReceiverIDs());
            }
            if (partnership2 == null) {
                throw new AS2PartnershipNotFoundException(partnership);
            }
            return partnership2;
        });
    }

    @Override
    @Nullable
    public Partnership getPartnershipByName(@Nullable String string) {
        return (Partnership)this.m_aRWLock.readLockedGet(() -> this.m_aPartnerships.getPartnershipByName(string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllPartnershipNames() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(this.m_aPartnerships::getAllPartnershipNames);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Partnership> getAllPartnerships() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(this.m_aPartnerships::getAllPartnerships);
    }

    @Nonnull
    public IPartnershipMap getPartnershipMap() {
        return (IPartnershipMap)this.m_aRWLock.readLockedGet(() -> this.m_aPartnerships);
    }

    protected final void setPartnerships(@Nonnull PartnershipMap partnershipMap) throws AS2Exception {
        this.m_aRWLock.writeLockedThrowing((IThrowingRunnable & Serializable)() -> {
            this.m_aPartnerships.setPartnerships(partnershipMap);
            this.markAsChanged();
        });
    }

    @Override
    @Nonnull
    public final EChange addPartnership(@Nonnull Partnership partnership) throws AS2Exception {
        return (EChange)this.m_aRWLock.writeLockedGetThrowing((IThrowingSupplier & Serializable)() -> {
            if (this.m_aPartnerships.addPartnership(partnership).isUnchanged()) {
                return EChange.UNCHANGED;
            }
            this.markAsChanged();
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    public final EChange removePartnership(@Nonnull Partnership partnership) throws AS2Exception {
        return (EChange)this.m_aRWLock.writeLockedGetThrowing((IThrowingSupplier & Serializable)() -> {
            if (this.m_aPartnerships.removePartnership(partnership).isUnchanged()) {
                return EChange.UNCHANGED;
            }
            this.markAsChanged();
            return EChange.CHANGED;
        });
    }

    @Override
    public void updatePartnership(@Nonnull IMessage iMessage, boolean bl) throws AS2Exception {
        String string;
        ValueEnforcer.notNull((Object)iMessage, (String)"Message");
        Partnership partnership = this.getPartnership(iMessage.partnership());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updating partnership " + partnership);
        }
        iMessage.partnership().copyFrom(partnership);
        if (bl && (string = partnership.getSubject()) != null) {
            iMessage.setSubject(new MessageParameters(iMessage).format(string));
        }
    }

    @Override
    public final void updatePartnership(@Nonnull IMessageMDN iMessageMDN, boolean bl) throws AS2Exception {
        ValueEnforcer.notNull((Object)iMessageMDN, (String)"MessageMDN");
        Partnership partnership = this.getPartnership(iMessageMDN.partnership());
        iMessageMDN.partnership().copyFrom(partnership);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Partnerships", (Object)this.m_aPartnerships).getToString();
    }
}

