/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.receiver.net;

import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.processor.receiver.net.INetModuleHandler;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.http.HTTPHelper;
import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.as2lib.util.http.IAS2InputStreamProvider;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.codec.IByteArrayCodec;
import com.helger.commons.codec.IdentityCodec;
import com.helger.commons.functional.IConsumer;
import com.helger.commons.string.StringHelper;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.mail.datasource.ByteArrayDataSource;
import java.io.IOException;
import java.net.Socket;
import java.security.cert.X509Certificate;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReceiverHandler
implements INetModuleHandler {
    public static final String MA_HTTP_ORIGINAL_CONTENT_TRANSFER_ENCODING = "HTTP_ORIGINAL_CONTENT_TRANSFER_ENCODING";
    public static final String MA_HTTP_ORIGINAL_CONTENT_LENGTH = "HTTP_ORIGINAL_CONTENT_LENGTH";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReceiverHandler.class);
    private IConsumer<X509Certificate> m_aVerificationCertificateConsumer;
    private IHTTPIncomingDumper m_aHttpIncomingDumper;

    @Nullable
    public final IConsumer<X509Certificate> getVerificationCertificateConsumer() {
        return this.m_aVerificationCertificateConsumer;
    }

    @Nonnull
    public final AbstractReceiverHandler setVerificationCertificateConsumer(@Nullable IConsumer<X509Certificate> iConsumer) {
        this.m_aVerificationCertificateConsumer = iConsumer;
        return this;
    }

    @Nullable
    public final IHTTPIncomingDumper getHttpIncomingDumper() {
        return this.m_aHttpIncomingDumper;
    }

    @Nullable
    public final IHTTPIncomingDumper getEffectiveHttpIncomingDumper() {
        IHTTPIncomingDumper iHTTPIncomingDumper = this.m_aHttpIncomingDumper;
        if (iHTTPIncomingDumper == null) {
            iHTTPIncomingDumper = HTTPHelper.getHTTPIncomingDumper();
        }
        return iHTTPIncomingDumper;
    }

    public final void setHttpIncomingDumper(@Nullable IHTTPIncomingDumper iHTTPIncomingDumper) {
        this.m_aHttpIncomingDumper = iHTTPIncomingDumper;
    }

    @Nonnull
    @Nonempty
    public String getClientInfo(@Nonnull Socket socket) {
        return socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
    }

    @Nonnull
    protected DataSource readAndDecodeHttpRequest(@Nonnull IAS2InputStreamProvider iAS2InputStreamProvider, @Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler, @Nonnull IMessage iMessage, @Nullable IHTTPIncomingDumper iHTTPIncomingDumper) throws IOException, MessagingException {
        DataSource dataSource = HTTPHelper.readHttpRequest(iAS2InputStreamProvider, iAS2HttpResponseHandler, iMessage, iHTTPIncomingDumper);
        String string = iMessage.partnership().getContentTransferEncodingReceive(EContentTransferEncoding.AS2_DEFAULT.getID());
        String string2 = iMessage.getHeaderOrDefault("Content-Transfer-Encoding", string);
        if (StringHelper.hasText((String)string2)) {
            EContentTransferEncoding eContentTransferEncoding = EContentTransferEncoding.getFromIDCaseInsensitiveOrNull((String)string2);
            if (eContentTransferEncoding == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Unsupported Content-Transfer-Encoding '" + string2 + "' is used - ignoring!");
                }
            } else {
                IByteArrayCodec iByteArrayCodec = eContentTransferEncoding.createCodec();
                if (!(iByteArrayCodec instanceof IdentityCodec) && dataSource instanceof ByteArrayDataSource) {
                    byte[] byArray = ((ByteArrayDataSource)dataSource).directGetBytes();
                    int n = byArray.length;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Incoming message uses Content-Transfer-Encoding '" + string2 + "' - decoding");
                    }
                    byArray = iByteArrayCodec.getDecoded(byArray);
                    dataSource = new ByteArrayDataSource(byArray, dataSource.getContentType(), dataSource.getName());
                    iMessage.attrs().putIn((Object)MA_HTTP_ORIGINAL_CONTENT_TRANSFER_ENCODING, (Object)string2);
                    iMessage.attrs().putIn(MA_HTTP_ORIGINAL_CONTENT_LENGTH, n);
                }
            }
        }
        return dataSource;
    }
}

