/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.dump;

import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.util.dump.IHTTPOutgoingDumper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.http.CHttp;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillCloseWhenClosed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPOutgoingDumperStreamBased
implements IHTTPOutgoingDumper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPOutgoingDumperStreamBased.class);
    private final OutputStream m_aOS;
    private boolean m_bDumpComment = false;
    private boolean m_bDumpHeader = true;
    private boolean m_bDumpPayload = true;
    private int m_nHeaders = 0;

    public HTTPOutgoingDumperStreamBased(@Nonnull @WillCloseWhenClosed OutputStream outputStream) {
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        this.m_aOS = outputStream;
    }

    @Nonnull
    protected final OutputStream getWrappedOS() {
        return this.m_aOS;
    }

    public final boolean isDumpComment() {
        return this.m_bDumpComment;
    }

    @Nonnull
    public final HTTPOutgoingDumperStreamBased setDumpComment(boolean bl) {
        this.m_bDumpComment = bl;
        return this;
    }

    public final boolean isDumpHeader() {
        return this.m_bDumpHeader;
    }

    @Nonnull
    public final HTTPOutgoingDumperStreamBased setDumpHeader(boolean bl) {
        this.m_bDumpHeader = bl;
        return this;
    }

    public final boolean isDumpPayload() {
        return this.m_bDumpPayload;
    }

    @Nonnull
    public final HTTPOutgoingDumperStreamBased setDumpPayload(boolean bl) {
        this.m_bDumpPayload = bl;
        return this;
    }

    private void _write(int n) {
        try {
            this.m_aOS.write(n);
        }
        catch (IOException iOException) {
            LOGGER.error("Error dumping byte", (Throwable)iOException);
        }
    }

    private void _write(@Nonnull byte[] byArray) {
        this._write(byArray, 0, byArray.length);
    }

    private void _write(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        try {
            this.m_aOS.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            LOGGER.error("Error dumping bytes", (Throwable)iOException);
        }
    }

    @Override
    public void start(@Nonnull String string, @Nonnull AS2Message aS2Message) {
        if (this.m_bDumpComment) {
            String string2 = "# Starting AS2 transmission to '" + string + "' with message ID " + aS2Message.getMessageID() + "\r\n";
            this._write(string2.getBytes(CHttp.HTTP_CHARSET));
        }
    }

    @Override
    public void dumpHeader(@Nonnull String string, @Nonnull String string2) {
        if (this.m_bDumpHeader) {
            String string3 = string + ": " + string2 + "\r\n";
            this._write(string3.getBytes(CHttp.HTTP_CHARSET));
            ++this.m_nHeaders;
        }
    }

    @Override
    public void finishedHeaders() {
        if (this.m_bDumpHeader && this.m_nHeaders > 0) {
            this._write("\r\n".getBytes(CHttp.HTTP_CHARSET));
        }
    }

    @Override
    public void dumpPayload(int n) {
        if (this.m_bDumpPayload) {
            this._write(n);
        }
    }

    @Override
    public void dumpPayload(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (this.m_bDumpPayload) {
            this._write(byArray, n, n2);
        }
    }

    @Override
    public void finishedPayload() {
        StreamHelper.flush((Flushable)this.m_aOS);
    }

    @Override
    public void close() {
        StreamHelper.close((AutoCloseable)this.m_aOS);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("OutputStream", (Object)this.m_aOS).getToString();
    }
}

