/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.cert;

import com.helger.as2lib.AbstractDynamicComponent;
import com.helger.as2lib.cert.AS2CertificateExistsException;
import com.helger.as2lib.cert.AS2CertificateNotFoundException;
import com.helger.as2lib.cert.AS2KeyNotFoundException;
import com.helger.as2lib.cert.ECertificatePartnershipType;
import com.helger.as2lib.cert.IAliasedCertificateFactory;
import com.helger.as2lib.cert.IKeyStoreCertificateFactory;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.IBaseMessage;
import com.helger.as2lib.partner.Partnership;
import com.helger.as2lib.session.IAS2Session;
import com.helger.as2lib.util.AS2Helper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractCertificateFactory
extends AbstractDynamicComponent
implements IKeyStoreCertificateFactory,
IAliasedCertificateFactory {
    public static final EKeyStoreType DEFAULT_KEY_STORE_TYPE = EKeyStoreType.PKCS12;
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_PASSWORD = "password";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCertificateFactory.class);
    @GuardedBy(value="m_aRWLock")
    private KeyStore m_aKeyStore;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bDebugLog = false;

    public final boolean isDebugLogEnabled() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bDebugLog);
    }

    public final void setDebugLogEnaled(boolean bl) {
        this.m_aRWLock.writeLockedBoolean(() -> {
            this.m_bDebugLog = bl;
            return this.m_bDebugLog;
        });
    }

    protected final void debugLog(@Nonnull Supplier<String> supplier) {
        if (this.isDebugLogEnabled()) {
            LOGGER.info(supplier.get());
        }
    }

    @Nullable
    public final String getKeyStoreType() {
        this.debugLog(() -> "getKeyStoreType ()");
        String string = (String)this.m_aRWLock.readLockedGet(() -> this.attrs().getAsString((Object)ATTR_TYPE));
        this.debugLog(() -> "getKeyStoreType -> " + string);
        return string;
    }

    public final void setKeyStoreType(@Nullable IKeyStoreType iKeyStoreType) {
        this.setKeyStoreType(iKeyStoreType == null ? null : (String)iKeyStoreType.getID());
    }

    public final void setKeyStoreType(@Nullable String string) {
        this.debugLog(() -> "setKeyStoreType (" + string + ")");
        this.m_aRWLock.writeLocked(() -> {
            if (string == null) {
                this.attrs().remove((Object)ATTR_TYPE);
            } else {
                this.attrs().putIn((Object)ATTR_TYPE, (Object)string);
            }
        });
    }

    public void setPassword(@Nullable String string) {
        this.debugLog(() -> "setPassword (***)");
        this.m_aRWLock.writeLockedGet(() -> this.attrs().putIn((Object)ATTR_PASSWORD, (Object)string));
    }

    @Nullable
    public char[] getPassword() {
        this.debugLog(() -> "getPassword ()");
        char[] cArray = (char[])this.m_aRWLock.readLockedGet(() -> this.attrs().getAsCharArray((Object)ATTR_PASSWORD));
        this.debugLog(() -> "getPassword -> ***");
        return cArray;
    }

    @Nonnull
    @Nonempty
    private static String _debug(@Nullable X509Certificate x509Certificate) {
        return x509Certificate == null ? "null" : x509Certificate.getSubjectX500Principal().getName() + "/" + x509Certificate.getSerialNumber().toString();
    }

    @Nonnull
    @Nonempty
    private static String _debug(@Nonnull Exception exception) {
        return exception.getClass().getName() + " - " + exception.getMessage();
    }

    @Nonnull
    @OverrideOnDemand
    protected KeyStore createNewKeyStore(@Nonnull EKeyStoreType eKeyStoreType) throws GeneralSecurityException {
        ValueEnforcer.notNull((Object)eKeyStoreType, (String)"KeystoreType");
        this.debugLog(() -> "createNewKeyStore (" + String.valueOf(eKeyStoreType) + ")");
        return AS2Helper.getCryptoHelper().createNewKeyStore((IKeyStoreType)eKeyStoreType);
    }

    @Override
    public void initDynamicComponent(@Nonnull IAS2Session iAS2Session, @Nullable IStringMap iStringMap) throws AS2Exception {
        this.debugLog(() -> "initDynamicComponent (" + String.valueOf(iAS2Session) + ", " + String.valueOf(iStringMap) + ")");
        super.initDynamicComponent(iAS2Session, iStringMap);
        this.reinitKeyStore();
        this.debugLog(() -> "initDynamicComponent -> done");
    }

    @Override
    @Nonnull
    public KeyStore getKeyStore() {
        KeyStore keyStore = (KeyStore)this.m_aRWLock.readLockedGet(() -> this.m_aKeyStore);
        if (keyStore == null) {
            throw new IllegalStateException("No keystore present");
        }
        return keyStore;
    }

    protected final void setKeyStore(@Nonnull KeyStore keyStore) {
        ValueEnforcer.notNull((Object)keyStore, (String)"KeyStore");
        this.debugLog(() -> "setKeyStore (" + String.valueOf(keyStore) + ")");
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_aKeyStore = keyStore;
            return this.m_aKeyStore;
        });
        this.debugLog(() -> "setKeyStore -> done");
    }

    protected void initEmptyKeyStore() throws AS2Exception {
        try {
            String string = this.getKeyStoreType();
            EKeyStoreType eKeyStoreType = EKeyStoreType.getFromIDCaseInsensitiveOrDefault((String)string, (EKeyStoreType)DEFAULT_KEY_STORE_TYPE);
            LOGGER.info("Using internal keystore of type " + String.valueOf(eKeyStoreType));
            KeyStore keyStore = this.createNewKeyStore(eKeyStoreType);
            if (keyStore == null) {
                this.debugLog(() -> "initDynamicComponent -> no keystore");
                throw new InitializationException("Failed to create new keystore with type " + String.valueOf(eKeyStoreType));
            }
            this.setKeyStore(keyStore);
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "initDynamicComponent -> " + AbstractCertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
    }

    @Nullable
    @OverrideOnDemand
    protected String getUnifiedAlias(@Nullable String string) {
        return string;
    }

    @Nonnull
    public String getAlias(@Nonnull Partnership partnership, @Nonnull ECertificatePartnershipType eCertificatePartnershipType) throws AS2Exception {
        String string;
        ValueEnforcer.notNull((Object)partnership, (String)"Partnership");
        ValueEnforcer.notNull((Object)((Object)eCertificatePartnershipType), (String)"PartnershipType");
        this.debugLog(() -> "getAlias (" + String.valueOf(partnership) + ", " + String.valueOf((Object)eCertificatePartnershipType) + ")");
        switch (eCertificatePartnershipType) {
            case RECEIVER: {
                string = partnership.getReceiverX509Alias();
                break;
            }
            case SENDER: {
                string = partnership.getSenderX509Alias();
                break;
            }
            default: {
                string = null;
            }
        }
        if (string == null) {
            this.debugLog(() -> "getAlias -> null");
            throw new AS2CertificateNotFoundException(eCertificatePartnershipType, partnership);
        }
        String string2 = this.getUnifiedAlias(string);
        this.debugLog(() -> "getAlias -> " + string2);
        return string2;
    }

    @Nonnull
    protected X509Certificate internalGetCertificate(@Nullable String string, @Nullable ECertificatePartnershipType eCertificatePartnershipType) throws AS2Exception {
        this.debugLog(() -> "internalGetCertificate (" + string + ", " + String.valueOf((Object)eCertificatePartnershipType) + ")");
        String string2 = this.getUnifiedAlias(string);
        this.m_aRWLock.readLock().lock();
        try {
            X509Certificate x509Certificate = (X509Certificate)this.m_aKeyStore.getCertificate(string2);
            if (x509Certificate == null) {
                throw new AS2CertificateNotFoundException(eCertificatePartnershipType, string2);
            }
            this.debugLog(() -> "internalGetCertificate -> " + AbstractCertificateFactory._debug(x509Certificate));
            X509Certificate x509Certificate2 = x509Certificate;
            return x509Certificate2;
        }
        catch (KeyStoreException keyStoreException) {
            this.debugLog(() -> "internalGetCertificate -> " + AbstractCertificateFactory._debug(keyStoreException));
            throw WrappedAS2Exception.wrap(keyStoreException);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    public X509Certificate getCertificate(@Nullable String string) throws AS2Exception {
        this.debugLog(() -> "getCertificate (" + string + ")");
        X509Certificate x509Certificate = this.internalGetCertificate(string, null);
        this.debugLog(() -> "getCertificate -> " + AbstractCertificateFactory._debug(x509Certificate));
        return x509Certificate;
    }

    @Override
    @Nonnull
    public X509Certificate getCertificate(@Nonnull IBaseMessage iBaseMessage, @Nonnull ECertificatePartnershipType eCertificatePartnershipType) throws AS2Exception {
        this.debugLog(() -> "getCertificate (" + iBaseMessage.getMessageID() + ", " + String.valueOf((Object)eCertificatePartnershipType) + ")");
        String string = this.getAlias(iBaseMessage.partnership(), eCertificatePartnershipType);
        X509Certificate x509Certificate = this.internalGetCertificate(string, eCertificatePartnershipType);
        this.debugLog(() -> "getCertificate -> " + AbstractCertificateFactory._debug(x509Certificate));
        return x509Certificate;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, X509Certificate> getCertificates() throws AS2Exception {
        this.debugLog(() -> "getCertificates ()");
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        this.m_aRWLock.readLock().lock();
        try {
            Enumeration<String> enumeration = this.m_aKeyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                commonsLinkedHashMap.put((Object)string, (Object)((X509Certificate)this.m_aKeyStore.getCertificate(string)));
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "getCertificates -> " + AbstractCertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.debugLog(() -> AbstractCertificateFactory.lambda$getCertificates$34((ICommonsOrderedMap)commonsLinkedHashMap));
        return commonsLinkedHashMap;
    }

    @OverrideOnDemand
    protected void onChange() throws AS2Exception {
    }

    @Nonnull
    private ICommonsList<String> _getAllAliases() {
        this.debugLog(() -> "_getAllAliases ()");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.m_aRWLock.readLock().lock();
        try {
            commonsArrayList.addAll(this.m_aKeyStore.aliases());
        }
        catch (KeyStoreException keyStoreException) {
            LOGGER.warn("Failed to determine all aliases from keystore", (Throwable)keyStoreException);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.debugLog(() -> AbstractCertificateFactory.lambda$_getAllAliases$36((ICommonsList)commonsArrayList));
        return commonsArrayList;
    }

    @Override
    @Nonnull
    public PrivateKey getPrivateKey(@Nullable X509Certificate x509Certificate) throws AS2Exception {
        this.debugLog(() -> "getPrivateKey (" + AbstractCertificateFactory._debug(x509Certificate) + ")");
        if (x509Certificate == null) {
            throw new AS2CertificateNotFoundException(x509Certificate);
        }
        ICommonsList<String> iCommonsList = this._getAllAliases();
        String string = null;
        this.m_aRWLock.readLock().lock();
        try {
            String string2;
            PrivateKey privateKey = null;
            Iterator iterator = iCommonsList.iterator();
            while (iterator.hasNext() && (!this.m_aKeyStore.getCertificate(string2 = (String)iterator.next()).equals(x509Certificate) || (privateKey = (PrivateKey)this.m_aKeyStore.getKey(string = this.getUnifiedAlias(string2), this.getPassword())) == null)) {
            }
            if (privateKey == null) {
                this.debugLog(() -> "getPrivateKey -> null");
                throw new AS2KeyNotFoundException(x509Certificate, string, iCommonsList, null);
            }
            iterator = privateKey;
            this.debugLog(() -> AbstractCertificateFactory.lambda$getPrivateKey$39((PrivateKey)((Object)iterator)));
            string2 = privateKey;
            return string2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "getPrivateKey -> " + AbstractCertificateFactory._debug(generalSecurityException));
            throw new AS2KeyNotFoundException(x509Certificate, string, iCommonsList, generalSecurityException);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    public void addCertificate(@Nonnull @Nonempty String string, @Nonnull X509Certificate x509Certificate, boolean bl) throws AS2Exception {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Alias");
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Cert");
        this.debugLog(() -> "addCertificate (" + string + ", " + AbstractCertificateFactory._debug(x509Certificate) + ", " + bl + ")");
        String string2 = this.getUnifiedAlias(string);
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aKeyStore.containsAlias(string2) && !bl) {
                throw new AS2CertificateExistsException(string2);
            }
            this.m_aKeyStore.setCertificateEntry(string2, x509Certificate);
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "addCertificate -> " + AbstractCertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        this.onChange();
        LOGGER.info("Added certificate alias '" + string2 + "' of certificate '" + AbstractCertificateFactory._debug(x509Certificate) + "'");
        this.debugLog(() -> "addCertificate -> done");
    }

    @Override
    public void addPrivateKey(@Nonnull @Nonempty String string, @Nonnull Key key, @Nonnull String string2) throws AS2Exception {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Alias");
        ValueEnforcer.notNull((Object)key, (String)"Key");
        ValueEnforcer.notNull((Object)string2, (String)"Password");
        this.debugLog(() -> "addPrivateKey (" + string + ", " + String.valueOf(key) + ", ***)");
        String string3 = this.getUnifiedAlias(string);
        this.m_aRWLock.writeLock().lock();
        try {
            if (!this.m_aKeyStore.containsAlias(string3)) {
                throw new AS2CertificateNotFoundException(null, string3);
            }
            Certificate[] certificateArray = this.m_aKeyStore.getCertificateChain(string3);
            this.m_aKeyStore.setKeyEntry(string3, key, string2.toCharArray(), certificateArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "addPrivateKey -> " + AbstractCertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        this.onChange();
        LOGGER.info("Added private key alias '" + string3 + "'");
        this.debugLog(() -> "addPrivateKey -> done");
    }

    @Override
    public void clearCertificates() throws AS2Exception {
        this.debugLog(() -> "clearCertificates ()");
        int n = 0;
        this.m_aRWLock.writeLock().lock();
        try {
            for (String string : CollectionHelper.newList(this.m_aKeyStore.aliases())) {
                this.m_aKeyStore.deleteEntry(string);
                ++n;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "clearCertificates -> " + AbstractCertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (n > 0) {
            this.onChange();
            LOGGER.info("Remove all aliases (" + n + ") in key store");
        }
        int n2 = n;
        this.debugLog(() -> "clearCertificates -> removed " + n2);
    }

    @Override
    public void removeCertificate(@Nonnull X509Certificate x509Certificate) throws AS2Exception {
        String string;
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Cert");
        this.debugLog(() -> "removeCertificate (" + AbstractCertificateFactory._debug(x509Certificate) + ")");
        this.m_aRWLock.readLock().lock();
        try {
            string = this.m_aKeyStore.getCertificateAlias(x509Certificate);
            if (string == null) {
                throw new AS2CertificateNotFoundException(x509Certificate);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "removeCertificate -> " + AbstractCertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.removeCertificate(string);
        this.debugLog(() -> "removeCertificate -> done");
    }

    @Override
    public void removeCertificate(@Nullable String string) throws AS2Exception {
        X509Certificate x509Certificate;
        this.debugLog(() -> "removeCertificate (" + string + ")");
        String string2 = this.getUnifiedAlias(string);
        this.m_aRWLock.writeLock().lock();
        try {
            x509Certificate = (X509Certificate)this.m_aKeyStore.getCertificate(string2);
            if (x509Certificate == null) {
                throw new AS2CertificateNotFoundException(null, string2);
            }
            this.m_aKeyStore.deleteEntry(string2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "removeCertificate -> " + AbstractCertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        this.onChange();
        LOGGER.info("Removed certificate alias '" + string2 + "' of certificate " + AbstractCertificateFactory._debug(x509Certificate));
        this.debugLog(() -> "removeCertificate -> done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(@Nonnull @WillClose InputStream inputStream, @Nonnull char[] cArray) throws AS2Exception {
        this.debugLog(() -> "load (" + String.valueOf(inputStream) + ", ***)");
        this.m_aRWLock.writeLock().lock();
        try {
            try {
                this.m_aKeyStore.load(inputStream, cArray);
            }
            catch (IOException | GeneralSecurityException exception) {
                this.debugLog(() -> "load -> " + AbstractCertificateFactory._debug(exception));
                throw WrappedAS2Exception.wrap(exception);
            }
            finally {
                StreamHelper.close((AutoCloseable)inputStream);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished loading keystore from an InputStream");
        }
        this.debugLog(() -> "load -> done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@Nonnull @WillClose OutputStream outputStream, @Nonnull char[] cArray) throws AS2Exception {
        this.debugLog(() -> "save (" + String.valueOf(outputStream) + ", ***)");
        this.m_aRWLock.writeLock().lock();
        try {
            try {
                this.m_aKeyStore.store(outputStream, cArray);
            }
            catch (IOException | GeneralSecurityException exception) {
                this.debugLog(() -> "save -> " + AbstractCertificateFactory._debug(exception));
                throw WrappedAS2Exception.wrap(exception);
            }
            finally {
                StreamHelper.close((AutoCloseable)outputStream);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished saving keystore to an OutputStream");
        }
        this.debugLog(() -> "save -> done");
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static /* synthetic */ String lambda$getPrivateKey$39(PrivateKey privateKey) {
        return "getPrivateKey -> " + String.valueOf(privateKey);
    }

    private static /* synthetic */ String lambda$_getAllAliases$36(ICommonsList iCommonsList) {
        return "_getAllAliases -> " + String.valueOf(iCommonsList);
    }

    private static /* synthetic */ String lambda$getCertificates$34(ICommonsOrderedMap iCommonsOrderedMap) {
        return "getCertificates -> " + new CommonsLinkedHashMap((Map)iCommonsOrderedMap, string -> string, AbstractCertificateFactory::_debug).toString();
    }
}

