/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.client;

import com.helger.as2lib.cert.AS2CertificateExistsException;
import com.helger.as2lib.cert.CertificateFactory;
import com.helger.as2lib.client.AS2ClientRequest;
import com.helger.as2lib.client.AS2ClientResponse;
import com.helger.as2lib.client.AS2ClientSettings;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.partner.Partnership;
import com.helger.as2lib.partner.SelfFillingPartnershipFactory;
import com.helger.as2lib.processor.DefaultMessageProcessor;
import com.helger.as2lib.processor.resender.ImmediateResenderModule;
import com.helger.as2lib.processor.sender.AS2SenderModule;
import com.helger.as2lib.session.AS2Session;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.factory.FactoryNewInstance;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.timing.StopWatch;
import com.helger.security.certificate.CertificateHelper;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.InputStream;
import java.net.Proxy;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2Client.class);
    private Supplier<AS2SenderModule> m_aAS2SenderModuleFactory = FactoryNewInstance.create(AS2SenderModule.class, (boolean)true);
    private Proxy m_aHttpProxy;

    @Nonnull
    public AS2Client setAS2SenderModuleFactory(@Nonnull Supplier<AS2SenderModule> supplier) {
        this.m_aAS2SenderModuleFactory = (Supplier)ValueEnforcer.notNull(supplier, (String)"AS2SenderModuleFactory");
        return this;
    }

    @Nullable
    public Proxy getHttpProxy() {
        return this.m_aHttpProxy;
    }

    @Nonnull
    public AS2Client setHttpProxy(@Nullable Proxy proxy) {
        this.m_aHttpProxy = proxy;
        return this;
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected Partnership buildPartnership(@Nonnull AS2ClientSettings aS2ClientSettings) {
        Partnership partnership = new Partnership(aS2ClientSettings.getPartnershipName());
        partnership.setSenderAS2ID(aS2ClientSettings.getSenderAS2ID());
        partnership.setSenderX509Alias(aS2ClientSettings.getSenderKeyAlias());
        partnership.setSenderEmail(aS2ClientSettings.getSenderEmailAddress());
        partnership.setReceiverAS2ID(aS2ClientSettings.getReceiverAS2ID());
        partnership.setReceiverX509Alias(aS2ClientSettings.getReceiverKeyAlias());
        partnership.setAS2URL(aS2ClientSettings.getDestinationAS2URL());
        partnership.setEncryptAlgorithm(aS2ClientSettings.getCryptAlgo());
        partnership.setSigningAlgorithm(aS2ClientSettings.getSignAlgo());
        partnership.setProtocol("as2");
        partnership.setMessageIDFormat(aS2ClientSettings.getMessageIDFormat());
        if (aS2ClientSettings.isMDNRequested()) {
            partnership.setAS2MDNTo(aS2ClientSettings.getSenderEmailAddress());
            partnership.setAS2MDNOptions(aS2ClientSettings.getMDNOptions());
            if (aS2ClientSettings.isAsyncMDNRequested()) {
                partnership.setAS2ReceiptDeliveryOption(aS2ClientSettings.getAsyncMDNUrl());
            } else {
                partnership.setAS2ReceiptDeliveryOption(null);
            }
        } else {
            partnership.setAS2MDNTo(null);
            partnership.setAS2ReceiptDeliveryOption(null);
            partnership.setAS2MDNOptions(null);
        }
        if (aS2ClientSettings.getCompressionType() != null) {
            partnership.setCompressionType(aS2ClientSettings.getCompressionType());
            partnership.setCompressionMode(aS2ClientSettings.isCompressBeforeSigning() ? "compress-before-signing" : "compress-after-signing");
        }
        return partnership;
    }

    @Nonnull
    @OverrideOnDemand
    protected AS2Message createAS2MessageObj() {
        return new AS2Message();
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected AS2Message createMessage(@Nonnull Partnership partnership, @Nonnull AS2ClientRequest aS2ClientRequest) throws MessagingException {
        AS2Message aS2Message = this.createAS2MessageObj();
        aS2Message.setContentType(aS2ClientRequest.getContentType());
        aS2Message.setSubject(aS2ClientRequest.getSubject());
        aS2Message.setPartnership(partnership);
        aS2Message.setMessageID(aS2Message.generateMessageID());
        aS2Message.attrs().putIn((Object)"as2_url", (Object)partnership.getAS2URL());
        aS2Message.attrs().putIn((Object)"as2_id", (Object)partnership.getReceiverAS2ID());
        aS2Message.attrs().putIn((Object)"email", (Object)partnership.getSenderEmail());
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        aS2ClientRequest.applyDataOntoMimeBodyPart(mimeBodyPart);
        aS2Message.setData(mimeBodyPart);
        return aS2Message;
    }

    @Nonnull
    @OverrideOnDemand
    protected CertificateFactory createCertificateFactory() {
        return new CertificateFactory();
    }

    @OverrideOnDemand
    protected void initCertificateFactory(@Nonnull AS2ClientSettings aS2ClientSettings, @Nonnull AS2Session aS2Session) throws AS2Exception {
        StringMap stringMap = new StringMap();
        stringMap.putIn((Object)"type", (Object)((String)aS2ClientSettings.getKeyStoreType().getID()));
        CertificateFactory certificateFactory = this.createCertificateFactory();
        certificateFactory.initDynamicComponent(aS2Session, (IStringMap)stringMap);
        if (aS2ClientSettings.getKeyStoreFile() != null) {
            LOGGER.info("Loading AS2 client keystore from file " + String.valueOf(aS2ClientSettings.getKeyStoreFile()));
            certificateFactory.setFilename(aS2ClientSettings.getKeyStoreFile().getAbsolutePath());
            certificateFactory.setPassword(aS2ClientSettings.getKeyStorePassword());
            certificateFactory.setSaveChangesToFile(aS2ClientSettings.isSaveKeyStoreChangesToFile());
            certificateFactory.load();
        } else if (aS2ClientSettings.getKeyStoreBytes() != null && aS2ClientSettings.getKeyStorePassword() != null) {
            LOGGER.info("Loading AS2 client keystore from byte array. No changes will be saved.");
            certificateFactory.setPassword(aS2ClientSettings.getKeyStorePassword());
            certificateFactory.setSaveChangesToFile(false);
            try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(aS2ClientSettings.getKeyStoreBytes());){
                certificateFactory.load((InputStream)nonBlockingByteArrayInputStream, aS2ClientSettings.getKeyStorePassword().toCharArray());
            }
        } else {
            LOGGER.warn("No AS2 client keystore data was provided. Signing and encryption/decryption will most likely fail.");
            certificateFactory.setSaveChangesToFile(false);
        }
        if (aS2ClientSettings.getReceiverCertificate() != null) {
            try {
                certificateFactory.addCertificate(aS2ClientSettings.getReceiverKeyAlias(), aS2ClientSettings.getReceiverCertificate(), false);
            }
            catch (AS2CertificateExistsException aS2CertificateExistsException) {
                // empty catch block
            }
        }
        aS2Session.setCertificateFactory(certificateFactory);
    }

    @OverrideOnDemand
    protected void initPartnershipFactory(@Nonnull AS2Session aS2Session) throws AS2Exception {
        SelfFillingPartnershipFactory selfFillingPartnershipFactory = new SelfFillingPartnershipFactory();
        selfFillingPartnershipFactory.initDynamicComponent(aS2Session, null);
        aS2Session.setPartnershipFactory(selfFillingPartnershipFactory);
    }

    @OverrideOnDemand
    protected void initMessageProcessor(@Nonnull AS2Session aS2Session) throws AS2Exception {
        DefaultMessageProcessor defaultMessageProcessor = new DefaultMessageProcessor();
        defaultMessageProcessor.initDynamicComponent(aS2Session, null);
        aS2Session.setMessageProcessor(defaultMessageProcessor);
    }

    @Nonnull
    @OverrideOnDemand
    protected AS2ClientResponse createResponse() {
        return new AS2ClientResponse();
    }

    @Nonnull
    @OverrideOnDemand
    protected AS2Session createSession() {
        AS2Session aS2Session = new AS2Session();
        aS2Session.setHttpProxy(this.m_aHttpProxy);
        return aS2Session;
    }

    @OverrideOnDemand
    protected void beforeSend(@Nonnull AS2ClientSettings aS2ClientSettings, @Nonnull AS2Session aS2Session, @Nonnull IMessage iMessage) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public AS2ClientResponse sendSynchronous(@Nonnull AS2ClientSettings aS2ClientSettings, @Nonnull AS2ClientRequest aS2ClientRequest) {
        ValueEnforcer.notNull((Object)aS2ClientSettings, (String)"ClientSettings");
        ValueEnforcer.notNull((Object)aS2ClientRequest, (String)"ClientRequest");
        AS2ClientResponse aS2ClientResponse = this.createResponse();
        IMessage iMessage = null;
        StopWatch stopWatch = StopWatch.createdStarted();
        try {
            ImmediateResenderModule immediateResenderModule;
            Partnership partnership = this.buildPartnership(aS2ClientSettings);
            iMessage = this.createMessage(partnership, aS2ClientRequest);
            aS2ClientResponse.setOriginalMessageID(iMessage.getMessageID());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("MessageID to send: " + iMessage.getMessageID());
            }
            boolean bl = aS2ClientSettings.getRetryCount() > 0;
            AS2Session aS2Session = this.createSession();
            this.initCertificateFactory(aS2ClientSettings, aS2Session);
            this.initPartnershipFactory(aS2Session);
            this.initMessageProcessor(aS2Session);
            if (bl) {
                immediateResenderModule = new ImmediateResenderModule();
                immediateResenderModule.initDynamicComponent(aS2Session, null);
                aS2Session.getMessageProcessor().addModule(immediateResenderModule);
            }
            aS2Session.getMessageProcessor().startActiveModules();
            try {
                this.beforeSend(aS2ClientSettings, aS2Session, iMessage);
                immediateResenderModule = new CommonsHashMap();
                if (bl) {
                    immediateResenderModule.put("retries", Integer.toString(aS2ClientSettings.getRetryCount()));
                }
                partnership.setContentTransferEncodingSend(aS2ClientRequest.getContentTransferEncoding());
                partnership.setContentTransferEncodingReceive(aS2ClientRequest.getContentTransferEncoding());
                AS2SenderModule aS2SenderModule = this.m_aAS2SenderModuleFactory.get();
                aS2SenderModule.initDynamicComponent(aS2Session, null);
                aS2SenderModule.setConnectTimeoutMilliseconds(aS2ClientSettings.getConnectTimeout().toMilliseconds());
                aS2SenderModule.setResponseTimeoutMilliseconds(aS2ClientSettings.getResponseTimeout().toMilliseconds());
                aS2SenderModule.setQuoteHeaderValues(aS2ClientSettings.isQuoteHeaderValues());
                if (aS2ClientSettings.getHttpOutgoingDumperFactory() != null) {
                    aS2SenderModule.setHttpOutgoingDumperFactory(aS2ClientSettings.getHttpOutgoingDumperFactory());
                }
                aS2SenderModule.setHttpIncomingDumper(aS2ClientSettings.getHttpIncomingDumper());
                if (aS2ClientSettings.getMICMatchingHandler() != null) {
                    aS2SenderModule.setMICMatchingHandler(aS2ClientSettings.getMICMatchingHandler());
                }
                aS2SenderModule.setVerificationCertificateConsumer(aS2ClientSettings.getVerificationCertificateConsumer());
                iMessage.headers().setAllHeaders(aS2ClientSettings.customHeaders());
                aS2Session.getMessageProcessor().addModule(aS2SenderModule);
                aS2SenderModule.handle("send", iMessage, (Map<String, Object>)((Object)immediateResenderModule));
            }
            finally {
                aS2Session.getMessageProcessor().stopActiveModules();
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error sending AS2 message", (Throwable)exception);
            aS2ClientResponse.setException(exception);
        }
        finally {
            if (iMessage != null && iMessage.getMDN() != null) {
                aS2ClientResponse.setMDN(iMessage.getMDN());
                String string = iMessage.attrs().getAsString((Object)"as2msg.received.signature.certificate");
                if (string != null) {
                    X509Certificate x509Certificate = CertificateHelper.convertStringToCertficateOrNull((String)string);
                    aS2ClientResponse.setMDNVerificationCertificate(x509Certificate);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Response retrieved: " + aS2ClientResponse.getAsString());
        }
        aS2ClientResponse.setExecutionDuration(stopWatch.stopAndGetDuration());
        return aS2ClientResponse;
    }
}

