/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.receiver.net;

import com.helger.as2lib.cert.ECertificatePartnershipType;
import com.helger.as2lib.cert.ICertificateFactory;
import com.helger.as2lib.crypto.ICryptoHelper;
import com.helger.as2lib.disposition.AS2DispositionException;
import com.helger.as2lib.disposition.DispositionType;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.message.IMessageMDN;
import com.helger.as2lib.params.MessageParameters;
import com.helger.as2lib.processor.AS2NoModuleException;
import com.helger.as2lib.processor.AS2ProcessorException;
import com.helger.as2lib.processor.receiver.AS2ReceiverModule;
import com.helger.as2lib.processor.receiver.AbstractActiveNetModule;
import com.helger.as2lib.processor.receiver.net.AS2NetException;
import com.helger.as2lib.processor.receiver.net.AbstractReceiverHandler;
import com.helger.as2lib.session.AS2ComponentNotFoundException;
import com.helger.as2lib.session.IAS2Session;
import com.helger.as2lib.util.AS2Helper;
import com.helger.as2lib.util.AS2HttpHelper;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.AS2ResourceHelper;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.http.AS2HttpRequestDataProviderInputStream;
import com.helger.as2lib.util.http.AS2HttpResponseHandlerSocket;
import com.helger.as2lib.util.http.HTTPHelper;
import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.as2lib.util.http.TempSharedFileInputStream;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.IWriteToStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.timing.StopWatch;
import com.helger.commons.wrapper.Wrapper;
import com.helger.mail.datasource.ByteArrayDataSource;
import com.helger.security.certificate.CertificateHelper;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.jcajce.ZlibExpanderProvider;
import org.bouncycastle.mail.smime.SMIMECompressedParser;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;
import org.bouncycastle.operator.InputExpanderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2ReceiverHandler
extends AbstractReceiverHandler {
    public static final boolean DEFAULT_SEND_EXCEPTIONS_IN_MDN = false;
    public static final boolean DEFAULT_SEND_EXCEPTION_STACKTRACE_IN_MDN = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2ReceiverHandler.class);
    private final AS2ReceiverModule m_aReceiverModule;
    private boolean m_bSendExceptionsInMDN = false;
    private boolean m_bSendExceptionStackTraceInMDN = false;

    public AS2ReceiverHandler(@Nonnull AS2ReceiverModule aS2ReceiverModule) {
        this.m_aReceiverModule = (AS2ReceiverModule)ValueEnforcer.notNull((Object)aS2ReceiverModule, (String)"Module");
    }

    @Nonnull
    protected final AS2ReceiverModule getReceiverModule() {
        return this.m_aReceiverModule;
    }

    public final boolean isSendExceptionsInMDN() {
        return this.m_bSendExceptionsInMDN;
    }

    @Nonnull
    public final AS2ReceiverHandler setSendExceptionsInMDN(boolean bl) {
        this.m_bSendExceptionsInMDN = bl;
        return this;
    }

    public final boolean isSendExceptionStackTraceInMDN() {
        return this.m_bSendExceptionStackTraceInMDN;
    }

    @Nonnull
    public final AS2ReceiverHandler setSendExceptionStackTraceInMDN(boolean bl) {
        this.m_bSendExceptionStackTraceInMDN = bl;
        return this;
    }

    @Nonnull
    protected AS2Message createMessage(@Nonnull Socket socket) {
        AS2Message aS2Message = new AS2Message();
        aS2Message.attrs().putIn((Object)"source_ip", (Object)socket.getInetAddress().getHostAddress());
        aS2Message.attrs().putIn("source_port", socket.getPort());
        aS2Message.attrs().putIn((Object)"destination_ip", (Object)socket.getLocalAddress().getHostAddress());
        aS2Message.attrs().putIn("destination_port", socket.getLocalPort());
        aS2Message.attrs().putIn("as2msg.received", true);
        return aS2Message;
    }

    protected void decrypt(@Nonnull IMessage iMessage, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws AS2Exception {
        ICertificateFactory iCertificateFactory = this.m_aReceiverModule.getSession().getCertificateFactory();
        ICryptoHelper iCryptoHelper = AS2Helper.getCryptoHelper();
        try {
            boolean bl = iMessage.partnership().isDisableDecrypt();
            boolean bl2 = iCryptoHelper.isEncrypted(iMessage.getData());
            boolean bl3 = iMessage.partnership().isForceDecrypt();
            if (bl2 && bl) {
                LOGGER.info("Message claims to be encrypted but decryption is disabled" + iMessage.getLoggingText());
            } else if (bl2 || bl3) {
                if (bl3 && !bl2) {
                    LOGGER.info("Forced decrypting" + iMessage.getLoggingText());
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Decrypting" + iMessage.getLoggingText());
                }
                X509Certificate x509Certificate = iCertificateFactory.getCertificate(iMessage, ECertificatePartnershipType.RECEIVER);
                PrivateKey privateKey = iCertificateFactory.getPrivateKey(x509Certificate);
                MimeBodyPart mimeBodyPart = iCryptoHelper.decrypt(iMessage.getData(), x509Certificate, privateKey, bl3, aS2ResourceHelper);
                iMessage.setData(mimeBodyPart);
                iMessage.attrs().putIn("as2msg.received.encrypted", true);
                LOGGER.info("Successfully decrypted incoming AS2 message" + iMessage.getLoggingText());
            }
        }
        catch (AS2DispositionException aS2DispositionException) {
            throw aS2DispositionException;
        }
        catch (Exception exception) {
            LOGGER.error("Error decrypting " + iMessage.getLoggingText(), (Throwable)exception);
            throw new AS2DispositionException(DispositionType.createError("decryption-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decrypting the content.", exception);
        }
    }

    protected void verify(@Nonnull IMessage iMessage, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws AS2Exception {
        ICertificateFactory iCertificateFactory = this.m_aReceiverModule.getSession().getCertificateFactory();
        ICryptoHelper iCryptoHelper = AS2Helper.getCryptoHelper();
        try {
            boolean bl = iMessage.partnership().isDisableVerify();
            boolean bl2 = iCryptoHelper.isSigned(iMessage.getData());
            boolean bl3 = iMessage.partnership().isForceVerify();
            if (bl2 && bl) {
                LOGGER.info("Message claims to be signed but signature validation is disabled" + iMessage.getLoggingText());
            } else if (bl2 || bl3) {
                if (bl3 && !bl2) {
                    LOGGER.info("Forced verify signature" + iMessage.getLoggingText());
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Verifying signature" + iMessage.getLoggingText());
                }
                X509Certificate x509Certificate = iCertificateFactory.getCertificateOrNull(iMessage, ECertificatePartnershipType.SENDER);
                ETriState eTriState = iMessage.partnership().getVerifyUseCertificateInBodyPart();
                boolean bl4 = eTriState.isDefined() ? eTriState.getAsBooleanValue() : this.m_aReceiverModule.getSession().isCryptoVerifyUseCertificateInBodyPart();
                Wrapper wrapper = new Wrapper();
                MimeBodyPart mimeBodyPart = iCryptoHelper.verify(iMessage.getData(), x509Certificate, bl4, bl3, arg_0 -> ((Wrapper)wrapper).set(arg_0), aS2ResourceHelper);
                Consumer<X509Certificate> consumer = this.getVerificationCertificateConsumer();
                if (consumer != null) {
                    consumer.accept((X509Certificate)wrapper.get());
                }
                iMessage.setData(mimeBodyPart);
                iMessage.attrs().putIn("as2msg.received.signed", true);
                iMessage.attrs().putIn((Object)"as2msg.received.signature.certificate", (Object)CertificateHelper.getPEMEncodedCertificate((Certificate)((Certificate)wrapper.get())));
                LOGGER.info("Successfully verified signature of incoming AS2 message" + iMessage.getLoggingText());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error verifying signature " + iMessage.getLoggingText() + ": " + exception.getMessage());
            throw AS2DispositionException.wrap(exception, () -> DispositionType.createError("integrity-check-failed"), () -> "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. Authentication of the originator of the message failed.");
        }
    }

    protected void decompress(@Nonnull IMessage iMessage) throws AS2DispositionException {
        try {
            if (iMessage.partnership().isDisableDecompress()) {
                LOGGER.info("Message claims to be compressed but decompression is disabled" + iMessage.getLoggingText());
            } else {
                StringBuilder stringBuilder;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Decompressing a compressed AS2 message");
                }
                ZlibExpanderProvider zlibExpanderProvider = new ZlibExpanderProvider();
                if (LOGGER.isDebugEnabled()) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("Headers before uncompress\n");
                    MimeBodyPart mimeBodyPart = iMessage.getData();
                    Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
                    while (enumeration.hasMoreElements()) {
                        stringBuilder.append((String)enumeration.nextElement()).append('\n');
                    }
                    stringBuilder.append("done");
                    LOGGER.debug(stringBuilder.toString());
                }
                stringBuilder = new SMIMECompressedParser(iMessage.getData());
                FileBackedMimeBodyPart fileBackedMimeBodyPart = SMIMEUtil.toMimeBodyPart((CMSTypedStream)stringBuilder.getContent((InputExpanderProvider)zlibExpanderProvider));
                iMessage.setData((MimeBodyPart)fileBackedMimeBodyPart);
                iMessage.attrs().putIn("as2msg.received.compressed", true);
                LOGGER.info("Successfully decompressed incoming AS2 message" + iMessage.getLoggingText());
            }
        }
        catch (MessagingException | CMSException | SMIMEException throwable) {
            LOGGER.error("Error decompressing received message", throwable);
            throw new AS2DispositionException(DispositionType.createError("unexpected-processing-error"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decompressing the content.", throwable);
        }
    }

    protected void sendMDN(@Nonnull String string, @Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler, @Nonnull AS2Message aS2Message, @Nonnull DispositionType dispositionType, @Nonnull String string2, @Nonnull ESuccess eSuccess) {
        block17: {
            boolean bl;
            boolean bl2 = bl = !aS2Message.partnership().isBlockErrorMDN();
            if (eSuccess.isSuccess() || bl) {
                try {
                    IAS2Session iAS2Session = this.m_aReceiverModule.getSession();
                    IMessageMDN iMessageMDN = AS2Helper.createMDN(iAS2Session, aS2Message, dispositionType, string2);
                    if (aS2Message.isRequestingAsynchMDN()) {
                        HttpHeaderMap httpHeaderMap = new HttpHeaderMap();
                        httpHeaderMap.setContentLength(0L);
                        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
                            iAS2HttpResponseHandler.sendHttpResponse(200, httpHeaderMap, (IWriteToStream)nonBlockingByteArrayOutputStream);
                        }
                        LOGGER.info("Setup to send async MDN [" + dispositionType.getAsString() + "] " + string + aS2Message.getLoggingText());
                        iAS2Session.getMessageProcessor().handle("sendmdn", aS2Message, null);
                        break block17;
                    }
                    LOGGER.info("Sending back sync MDN [" + dispositionType.getAsString() + "] " + string + aS2Message.getLoggingText());
                    try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
                        MimeBodyPart mimeBodyPart = iMessageMDN.getData();
                        StreamHelper.copyInputStreamToOutputStream((InputStream)mimeBodyPart.getInputStream(), (OutputStream)nonBlockingByteArrayOutputStream);
                        iMessageMDN.headers().setContentLength((long)nonBlockingByteArrayOutputStream.size());
                        iAS2HttpResponseHandler.sendHttpResponse(200, iMessageMDN.headers(), (IWriteToStream)nonBlockingByteArrayOutputStream);
                    }
                    try {
                        iAS2Session.getMessageProcessor().handle("storemdn", aS2Message, null);
                    }
                    catch (AS2NoModuleException | AS2ComponentNotFoundException aS2Exception) {
                        // empty catch block
                    }
                    LOGGER.info("sent MDN [" + dispositionType.getAsString() + "] " + string + aS2Message.getLoggingText());
                }
                catch (Exception exception) {
                    WrappedAS2Exception.wrap(exception).terminate(aS2Message);
                }
            }
        }
    }

    @Nonnull
    private String _getDispositionText(@Nonnull AS2Exception aS2Exception) {
        if (this.m_bSendExceptionsInMDN) {
            String string = this.m_bSendExceptionStackTraceInMDN ? StackTraceHelper.getStackAsString((Throwable)aS2Exception, (boolean)true, (String)"\r\n") : (aS2Exception instanceof AS2ProcessorException ? ((AS2ProcessorException)aS2Exception).getShortToString() : aS2Exception.toString());
            return "\r\n" + MessageParameters.getEscapedString(string);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIncomingMessage(@Nonnull String string, @Nonnull DataSource dataSource, @Nonnull AS2Message aS2Message, @Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler) {
        try (AS2ResourceHelper aS2ResourceHelper = new AS2ResourceHelper();){
            try {
                Object object;
                Object object2;
                IAS2Session iAS2Session = this.m_aReceiverModule.getSession();
                try {
                    object2 = AS2HttpHelper.getCleanContentType(aS2Message.getHeader("Content-Type"));
                    object = new MimeBodyPart();
                    object.setDataHandler(new DataHandler(dataSource));
                    object.setHeader("Content-Type", (String)object2);
                    aS2Message.setData((MimeBodyPart)object);
                }
                catch (Exception exception) {
                    throw new AS2DispositionException(DispositionType.createError("unexpected-processing-error"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured while parsing the MIME content.", exception);
                }
                try {
                    object2 = aS2Message.getAS2From();
                    aS2Message.partnership().setSenderAS2ID((String)object2);
                    object = aS2Message.getAS2To();
                    aS2Message.partnership().setReceiverAS2ID((String)object);
                    iAS2Session.getPartnershipFactory().updatePartnership(aS2Message, false);
                }
                catch (AS2Exception aS2Exception) {
                    throw AS2DispositionException.wrap(aS2Exception, () -> DispositionType.createError("authentication-failed"), () -> "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but the Sender $sender.as2_id$ and/or Recipient $receiver.as2_id$ are unknown.");
                }
                object2 = AS2Helper.getCryptoHelper();
                boolean bl = false;
                this.decrypt(aS2Message, aS2ResourceHelper);
                if (object2.isCompressed(aS2Message.getContentType())) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Decompressing received message before checking signature...");
                    }
                    this.decompress(aS2Message);
                    bl = true;
                }
                this.verify(aS2Message, aS2ResourceHelper);
                if (object2.isCompressed(aS2Message.getContentType())) {
                    if (bl) {
                        throw new AS2DispositionException(DispositionType.createError("decompression-failed"), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decompressing the content.", new Exception("Message has already been decompressed. Per RFC5402 it cannot occur twice."));
                    }
                    if (LOGGER.isTraceEnabled()) {
                        if (aS2Message.attrs().containsKey((Object)"as2msg.received.signed")) {
                            LOGGER.trace("Decompressing received message after verifying signature...");
                        } else {
                            LOGGER.trace("Decompressing received message after decryption...");
                        }
                    }
                    this.decompress(aS2Message);
                    bl = true;
                }
                if (LOGGER.isTraceEnabled()) {
                    try {
                        LOGGER.trace("SMIME Decrypted Content-Disposition: " + aS2Message.getContentDisposition() + "\n      Content-Type received: " + aS2Message.getContentType() + "\n      HEADERS after decryption: " + String.valueOf(aS2Message.getData().getAllHeaders()) + "\n      Content-Disposition in MSG detData() MIMEPART after decryption: " + aS2Message.getData().getContentType());
                    }
                    catch (MessagingException messagingException) {
                        LOGGER.error("Failed to trace message: " + String.valueOf(aS2Message), (Throwable)messagingException);
                    }
                }
                try {
                    iAS2Session.getMessageProcessor().handle("validate-before-store", aS2Message, null);
                }
                catch (AS2NoModuleException aS2NoModuleException) {
                }
                catch (AS2Exception aS2Exception) {
                    throw AS2DispositionException.wrap(aS2Exception, () -> DispositionType.createError("unexpected-processing-error"), () -> StringHelper.getConcatenatedOnDemand((String)"The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message. An error occured while validating the received data.", (String)"\r\n", (String)this._getDispositionText(aS2Exception)));
                }
                try {
                    iAS2Session.getMessageProcessor().handle("store", aS2Message, null);
                }
                catch (AS2NoModuleException aS2NoModuleException) {
                }
                catch (AS2Exception aS2Exception) {
                    throw AS2DispositionException.wrap(aS2Exception, () -> DispositionType.createError("unexpected-processing-error"), () -> StringHelper.getConcatenatedOnDemand((String)"The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message. An error occured while storing the data to the file system.", (String)"\r\n", (String)this._getDispositionText(aS2Exception)));
                }
                try {
                    iAS2Session.getMessageProcessor().handle("validate-after-store", aS2Message, null);
                }
                catch (AS2NoModuleException aS2NoModuleException) {
                }
                catch (AS2Exception aS2Exception) {
                    throw AS2DispositionException.wrap(aS2Exception, () -> DispositionType.createError("unexpected-processing-error"), () -> StringHelper.getConcatenatedOnDemand((String)"The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message. An error occured while validating the received data.", (String)"\r\n", (String)this._getDispositionText(aS2Exception)));
                }
                try {
                    if (aS2Message.isRequestingMDN()) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("AS2 message is requesting an MDN");
                        }
                        this.sendMDN(string, iAS2HttpResponseHandler, aS2Message, DispositionType.createSuccess(), "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message. There is no guarantee however that the EDI Interchange was syntactically correct, or was received by the EDI application/translator.", ESuccess.SUCCESS);
                    } else {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("AS2 message is not requesting an MDN - just sending HTTP 200 (OK)");
                        }
                        HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 200);
                        LOGGER.info("sent HTTP OK " + string + aS2Message.getLoggingText());
                    }
                }
                catch (Exception exception) {
                    throw new AS2Exception("Error creating and returning MDN, message was stilled processed", exception);
                }
            }
            catch (AS2DispositionException aS2DispositionException) {
                this.sendMDN(string, iAS2HttpResponseHandler, aS2Message, aS2DispositionException.getDisposition(), aS2DispositionException.getText(), ESuccess.FAILURE);
                this.m_aReceiverModule.handleError(aS2Message, aS2DispositionException);
            }
            catch (AS2Exception aS2Exception) {
                this.m_aReceiverModule.handleError(aS2Message, aS2Exception);
            }
            finally {
                TempSharedFileInputStream tempSharedFileInputStream = aS2Message.getTempSharedFileInputStream();
                if (null != tempSharedFileInputStream) {
                    try {
                        tempSharedFileInputStream.closeAndDelete();
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Exception while closing TempSharedFileInputStream", (Throwable)iOException);
                    }
                }
            }
        }
    }

    @Override
    public void handle(@Nonnull AbstractActiveNetModule abstractActiveNetModule, @Nonnull Socket socket) {
        String string = this.getClientInfo(socket);
        LOGGER.info("Incoming connection " + string);
        AS2Message aS2Message = this.createMessage(socket);
        boolean bl = this.m_aReceiverModule.isQuoteHeaderValues();
        AS2HttpResponseHandlerSocket aS2HttpResponseHandlerSocket = new AS2HttpResponseHandlerSocket(socket, bl);
        StopWatch stopWatch = StopWatch.createdStarted();
        DataSource dataSource = null;
        try {
            IHTTPIncomingDumper iHTTPIncomingDumper = this.getEffectiveHttpIncomingDumper();
            dataSource = HTTPHelper.readAndDecodeHttpRequest(new AS2HttpRequestDataProviderInputStream(socket.getInputStream()), aS2HttpResponseHandlerSocket, aS2Message, iHTTPIncomingDumper);
        }
        catch (Exception exception) {
            new AS2NetException(socket.getInetAddress(), socket.getPort(), exception).terminate();
        }
        stopWatch.stop();
        if (dataSource == null) {
            LOGGER.error("Not having a data source to operate on");
        } else {
            if (dataSource instanceof ByteArrayDataSource) {
                LOGGER.info("received " + AS2IOHelper.getTransferRate(((ByteArrayDataSource)dataSource).directGetBytes().length, stopWatch) + " from " + string + aS2Message.getLoggingText());
            } else {
                LOGGER.info("received message from " + string + aS2Message.getLoggingText() + " in " + stopWatch.getMillis() + " ms");
            }
            this.handleIncomingMessage(string, dataSource, aS2Message, aS2HttpResponseHandlerSocket);
        }
    }
}

