/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2servlet;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.session.AS2Session;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.http.HTTPHelper;
import com.helger.as2lib.util.http.IAS2HttpRequestDataProvider;
import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.as2servlet.AS2HttpRequestDataProviderServletRequest;
import com.helger.as2servlet.util.AS2OutputStreamCreatorHttpServletResponse;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.timing.StopWatch;
import com.helger.http.EHttpVersion;
import com.helger.mail.datasource.ByteArrayDataSource;
import com.helger.servlet.ServletHelper;
import com.helger.web.scope.IRequestWebScope;
import com.helger.xservlet.handler.IXServletHandler;
import java.io.IOException;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAS2ReceiveBaseXServletHandler
implements IXServletHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAS2ReceiveBaseXServletHandler.class);
    private AS2Session m_aSession;
    private IHTTPIncomingDumper m_aHttpIncomingDumper;

    @Nonnull
    @OverrideOnDemand
    protected abstract AS2Session createAS2Session(@Nonnull ICommonsMap<String, String> var1) throws AS2Exception, ServletException;

    @OverridingMethodsMustInvokeSuper
    public void onServletInit(@Nonnull ICommonsMap<String, String> iCommonsMap) throws ServletException {
        try {
            this.m_aSession = this.createAS2Session(iCommonsMap);
        }
        catch (AS2Exception aS2Exception) {
            throw new ServletException("Failed to init AS2 configuration", (Throwable)aS2Exception);
        }
    }

    @Nonnull
    protected final AS2Session getSession() {
        if (this.m_aSession == null) {
            throw new IllegalStateException("This servlet was not initialized properly! No AS2 session is present.");
        }
        return this.m_aSession;
    }

    @Nullable
    public final IHTTPIncomingDumper getHttpIncomingDumper() {
        return this.m_aHttpIncomingDumper;
    }

    @Nullable
    public final IHTTPIncomingDumper getEffectiveHttpIncomingDumper() {
        IHTTPIncomingDumper iHTTPIncomingDumper = this.m_aHttpIncomingDumper;
        if (iHTTPIncomingDumper == null) {
            iHTTPIncomingDumper = HTTPHelper.getHTTPIncomingDumper();
        }
        return iHTTPIncomingDumper;
    }

    public final void setHttpIncomingDumper(@Nullable IHTTPIncomingDumper iHTTPIncomingDumper) {
        this.m_aHttpIncomingDumper = iHTTPIncomingDumper;
    }

    protected abstract boolean isQuoteHeaderValues();

    protected abstract void handleIncomingMessage(@Nonnull String var1, @Nonnull DataSource var2, @Nonnull AS2Message var3, @Nonnull IAS2HttpResponseHandler var4) throws ServletException;

    public final void onRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull IRequestWebScope iRequestWebScope) throws ServletException, IOException {
        String string = httpServletRequest.getRemoteAddr() + ":" + httpServletRequest.getRemotePort();
        LOGGER.info("Starting to handle incoming AS2 request - " + string);
        AS2Message aS2Message = new AS2Message();
        aS2Message.attrs().putIn((Object)"source_ip", (Object)httpServletRequest.getRemoteAddr());
        aS2Message.attrs().putIn("source_port", httpServletRequest.getRemotePort());
        aS2Message.attrs().putIn((Object)"destination_ip", (Object)httpServletRequest.getLocalAddr());
        aS2Message.attrs().putIn("destination_port", httpServletRequest.getLocalPort());
        aS2Message.attrs().putIn((Object)"HTTP_REQUEST_TYPE", (Object)httpServletRequest.getMethod());
        aS2Message.attrs().putIn((Object)"HTTP_REQUEST_URL", (Object)ServletHelper.getRequestRequestURI((HttpServletRequest)httpServletRequest));
        aS2Message.headers().setAllHeaders(iRequestWebScope.headers());
        boolean bl = this.isQuoteHeaderValues();
        AS2OutputStreamCreatorHttpServletResponse aS2OutputStreamCreatorHttpServletResponse = new AS2OutputStreamCreatorHttpServletResponse(httpServletResponse, bl);
        long l = httpServletRequest.getContentLengthLong();
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException("Currently only payload with up to 2GB can be handled! This request has " + l + " bytes.");
        }
        try (ServletInputStream servletInputStream = httpServletRequest.getInputStream();){
            StopWatch stopWatch = StopWatch.createdStarted();
            DataSource dataSource = null;
            try {
                IHTTPIncomingDumper iHTTPIncomingDumper = this.getEffectiveHttpIncomingDumper();
                dataSource = HTTPHelper.readAndDecodeHttpRequest((IAS2HttpRequestDataProvider)new AS2HttpRequestDataProviderServletRequest(iRequestWebScope, servletInputStream), (IAS2HttpResponseHandler)aS2OutputStreamCreatorHttpServletResponse, (IMessage)aS2Message, (IHTTPIncomingDumper)iHTTPIncomingDumper);
            }
            catch (Exception exception) {
                AS2Exception.log(exception.getClass(), (boolean)true, (String)("Failed to read Servlet Request: " + exception.getMessage()), null, null, (Throwable)exception.getCause());
            }
            stopWatch.stop();
            if (dataSource == null) {
                LOGGER.error("Not having a data source to operate on");
            } else {
                if (dataSource instanceof ByteArrayDataSource) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("received " + AS2IOHelper.getTransferRate((long)((ByteArrayDataSource)dataSource).directGetBytes().length, (StopWatch)stopWatch) + " from " + string + aS2Message.getLoggingText());
                    }
                } else {
                    LOGGER.info("received message from " + string + aS2Message.getLoggingText() + " in " + stopWatch.getMillis() + " ms");
                }
                this.handleIncomingMessage(string, dataSource, aS2Message, aS2OutputStreamCreatorHttpServletResponse);
            }
        }
    }
}

