/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.ws;

import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.string.ToStringGenerator;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustManagerTrustAll
implements X509TrustManager {
    private static final Logger s_aLogger = LoggerFactory.getLogger(TrustManagerTrustAll.class);
    private final boolean m_bDebug;

    public TrustManagerTrustAll() {
        this(GlobalDebug.isDebugMode());
    }

    public TrustManagerTrustAll(boolean bl) {
        this.m_bDebug = bl;
    }

    public boolean isDebug() {
        return this.m_bDebug;
    }

    @Override
    @Nullable
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        if (this.m_bDebug && s_aLogger.isInfoEnabled()) {
            s_aLogger.info("checkServerTrusted (" + Arrays.toString(x509CertificateArray) + ", " + string + ")");
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        if (this.m_bDebug && s_aLogger.isInfoEnabled()) {
            s_aLogger.info("checkClientTrusted (" + Arrays.toString(x509CertificateArray) + ", " + string + ")");
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("debug", this.m_bDebug).getToString();
    }
}

