/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.id.factory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.id.factory.IIntIDFactory;
import com.helger.commons.id.factory.ILongIDFactory;
import com.helger.commons.id.factory.IStringIDFactory;
import com.helger.commons.id.factory.MemoryIntIDFactory;
import com.helger.commons.id.factory.MemoryLongIDFactory;
import com.helger.commons.id.factory.StringIDFromGlobalIntIDFactory;
import com.helger.commons.id.factory.StringIDFromGlobalPersistentIntIDFactory;
import com.helger.commons.state.EChange;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GlobalIDFactory {
    public static final String DEFAULT_PREFIX = "id";
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalIDFactory.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static IIntIDFactory s_aIntIDFactory = new MemoryIntIDFactory();
    private static IIntIDFactory s_aPersistentIntIDFactory;
    private static ILongIDFactory s_aLongIDFactory;
    private static ILongIDFactory s_aPersistentLongIDFactory;
    private static IStringIDFactory s_aStringIDFactory;
    private static IStringIDFactory s_aPersistentStringIDFactory;
    private static final GlobalIDFactory s_aInstance;

    private GlobalIDFactory() {
    }

    public static boolean hasIntIDFactory() {
        return GlobalIDFactory.getIntIDFactory() != null;
    }

    @Nullable
    public static IIntIDFactory getIntIDFactory() {
        return s_aRWLock.readLocked(() -> s_aIntIDFactory);
    }

    @Nonnull
    public static EChange setIntIDFactory(@Nullable IIntIDFactory iIntIDFactory) {
        return s_aRWLock.writeLocked(() -> {
            if (EqualsHelper.equals(s_aIntIDFactory, iIntIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Setting in-memory int ID factory " + iIntIDFactory);
            }
            s_aIntIDFactory = iIntIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasPersistentIntIDFactory() {
        return GlobalIDFactory.getPersistentIntIDFactory() != null;
    }

    @Nullable
    public static IIntIDFactory getPersistentIntIDFactory() {
        return s_aRWLock.readLocked(() -> s_aPersistentIntIDFactory);
    }

    @Nonnull
    public static EChange setPersistentIntIDFactory(@Nullable IIntIDFactory iIntIDFactory) {
        return s_aRWLock.writeLocked(() -> {
            if (EqualsHelper.equals(s_aPersistentIntIDFactory, iIntIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Setting persistent int ID factory " + iIntIDFactory);
            }
            s_aPersistentIntIDFactory = iIntIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasLongIDFactory() {
        return GlobalIDFactory.getLongIDFactory() != null;
    }

    @Nullable
    public static ILongIDFactory getLongIDFactory() {
        return s_aRWLock.readLocked(() -> s_aLongIDFactory);
    }

    @Nonnull
    public static EChange setLongIDFactory(@Nullable ILongIDFactory iLongIDFactory) {
        return s_aRWLock.writeLocked(() -> {
            if (EqualsHelper.equals(s_aLongIDFactory, iLongIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Setting in-memory long ID factory " + iLongIDFactory);
            }
            s_aLongIDFactory = iLongIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasPersistentLongIDFactory() {
        return GlobalIDFactory.getPersistentLongIDFactory() != null;
    }

    @Nullable
    public static ILongIDFactory getPersistentLongIDFactory() {
        return s_aRWLock.readLocked(() -> s_aPersistentLongIDFactory);
    }

    @Nonnull
    public static EChange setPersistentLongIDFactory(@Nullable ILongIDFactory iLongIDFactory) {
        return s_aRWLock.writeLocked(() -> {
            if (EqualsHelper.equals(s_aPersistentLongIDFactory, iLongIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Setting persistent long ID factory " + iLongIDFactory);
            }
            s_aPersistentLongIDFactory = iLongIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasStringIDFactory() {
        return GlobalIDFactory.getStringIDFactory() != null;
    }

    @Nullable
    public static IStringIDFactory getStringIDFactory() {
        return s_aRWLock.readLocked(() -> s_aStringIDFactory);
    }

    @Nonnull
    public static EChange setStringIDFactory(@Nullable IStringIDFactory iStringIDFactory) {
        return s_aRWLock.writeLocked(() -> {
            if (EqualsHelper.equals(s_aStringIDFactory, iStringIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Setting in-memory string ID factory " + iStringIDFactory);
            }
            s_aStringIDFactory = iStringIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasPersistentStringIDFactory() {
        return GlobalIDFactory.getPersistentStringIDFactory() != null;
    }

    @Nullable
    public static IStringIDFactory getPersistentStringIDFactory() {
        return s_aRWLock.readLocked(() -> s_aPersistentStringIDFactory);
    }

    @Nonnull
    public static EChange setPersistentStringIDFactory(@Nullable IStringIDFactory iStringIDFactory) {
        return s_aRWLock.writeLocked(() -> {
            if (EqualsHelper.equals(s_aPersistentStringIDFactory, iStringIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Setting persistent string ID factory " + iStringIDFactory);
            }
            s_aPersistentStringIDFactory = iStringIDFactory;
            return EChange.CHANGED;
        });
    }

    public static int getNewIntID() {
        return s_aRWLock.readLocked(() -> {
            if (s_aIntIDFactory == null) {
                throw new IllegalStateException("No in-memory int ID factory has been supplied!");
            }
            return s_aIntIDFactory.getNewID();
        });
    }

    public static int getNewPersistentIntID() {
        return s_aRWLock.readLocked(() -> {
            if (s_aPersistentIntIDFactory == null) {
                throw new IllegalStateException("No persistent int ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            return s_aPersistentIntIDFactory.getNewID();
        });
    }

    public static long getNewLongID() {
        return s_aRWLock.readLocked(() -> {
            if (s_aLongIDFactory == null) {
                throw new IllegalStateException("No in-memory long ID factory has been supplied!");
            }
            return s_aLongIDFactory.getNewID();
        });
    }

    public static long getNewPersistentLongID() {
        return s_aRWLock.readLocked(() -> {
            if (s_aPersistentLongIDFactory == null) {
                throw new IllegalStateException("No persistent long ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            return s_aPersistentLongIDFactory.getNewID();
        });
    }

    @Nonnull
    public static String getNewStringID() {
        return s_aRWLock.readLocked(() -> {
            if (s_aStringIDFactory == null) {
                throw new IllegalStateException("No in-memory string ID factory has been supplied!");
            }
            return (String)s_aStringIDFactory.getNewID();
        });
    }

    @Nonnull
    public static String getNewPersistentStringID() {
        return s_aRWLock.readLocked(() -> {
            if (s_aPersistentStringIDFactory == null) {
                throw new IllegalStateException("No persistent string ID factory has been supplied!");
            }
            return (String)s_aPersistentStringIDFactory.getNewID();
        });
    }

    public static int[] getBulkNewIntIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return s_aRWLock.readLocked(() -> {
            if (s_aIntIDFactory == null) {
                throw new IllegalStateException("No in-memory int ID factory has been supplied!");
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = s_aIntIDFactory.getNewID();
            }
            return nArray;
        });
    }

    public static int[] getBulkNewPersistentIntIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return s_aRWLock.readLocked(() -> {
            if (s_aPersistentIntIDFactory == null) {
                throw new IllegalStateException("No persistent int ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = s_aPersistentIntIDFactory.getNewID();
            }
            return nArray;
        });
    }

    public static long[] getBulkNewLongIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return s_aRWLock.readLocked(() -> {
            if (s_aLongIDFactory == null) {
                throw new IllegalStateException("No in-memory long ID factory has been supplied!");
            }
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = s_aLongIDFactory.getNewID();
            }
            return lArray;
        });
    }

    public static long[] getBulkNewPersistentLongIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return s_aRWLock.readLocked(() -> {
            if (s_aPersistentLongIDFactory == null) {
                throw new IllegalStateException("No persistent long ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = s_aPersistentLongIDFactory.getNewID();
            }
            return lArray;
        });
    }

    @Nonnull
    public static String[] getBulkNewStringIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return s_aRWLock.readLocked(() -> {
            if (s_aStringIDFactory == null) {
                throw new IllegalStateException("No in-memory string ID factory has been supplied!");
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)s_aStringIDFactory.getNewID();
            }
            return stringArray;
        });
    }

    @Nonnull
    public static String[] getBulkNewPersistentStringIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return s_aRWLock.readLocked(() -> {
            if (s_aPersistentStringIDFactory == null) {
                throw new IllegalStateException("No persistent string ID factory has been supplied!");
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)s_aPersistentStringIDFactory.getNewID();
            }
            return stringArray;
        });
    }

    static {
        s_aLongIDFactory = new MemoryLongIDFactory();
        s_aStringIDFactory = new StringIDFromGlobalIntIDFactory();
        s_aPersistentStringIDFactory = new StringIDFromGlobalPersistentIntIDFactory();
        s_aInstance = new GlobalIDFactory();
    }
}

