/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.QValue;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class AbstractQValueList<KEYTYPE extends Serializable>
implements Serializable {
    private final ICommonsOrderedMap<KEYTYPE, QValue> m_aMap = new CommonsLinkedHashMap();

    @Nonnull
    @ReturnsMutableCopy
    protected final ICommonsOrderedMap<KEYTYPE, QValue> qvalueMap() {
        return this.m_aMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<KEYTYPE, QValue> getAllQValues() {
        return this.m_aMap.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesLowerThan(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() < d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesLowerOrEqual(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() <= d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesGreaterThan(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() > d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<KEYTYPE, QValue> getAllQValuesGreaterOrEqual(double d) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            QValue qValue = (QValue)entry.getValue();
            if (!(qValue.getQuality() >= d)) continue;
            commonsLinkedHashMap.put(entry.getKey(), (Object)qValue);
        }
        return commonsLinkedHashMap;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }
}

