/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.ValueEnforcer;
import com.helger.http.AbstractQValueList;
import com.helger.http.AcceptCharsetHandler;
import com.helger.http.QValue;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class AcceptCharsetList
extends AbstractQValueList<String> {
    @Nonnull
    private static String _unify(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    public void addCharset(@Nonnull String string, @Nonnegative double d) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Charset");
        this.qvalueMap().put((Object)AcceptCharsetList._unify(string), (Object)new QValue(d));
    }

    @Nonnull
    public QValue getQValueOfCharset(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Charset");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptCharsetList._unify(string));
        if (qValue == null && (qValue = (QValue)this.qvalueMap().get((Object)"*")) == null) {
            return string.equals(AcceptCharsetHandler.DEFAULT_CHARSET) ? QValue.MAX_QVALUE : QValue.MIN_QVALUE;
        }
        return qValue;
    }

    public double getQualityOfCharset(@Nonnull String string) {
        return this.getQValueOfCharset(string).getQuality();
    }

    public boolean supportsCharset(@Nonnull String string) {
        return this.getQValueOfCharset(string).isAboveMinimumQuality();
    }

    public boolean explicitlySupportsCharset(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Charset");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptCharsetList._unify(string));
        return qValue != null && qValue.isAboveMinimumQuality();
    }
}

