/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.ValueEnforcer;
import com.helger.http.AbstractQValueList;
import com.helger.http.QValue;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class AcceptLanguageList
extends AbstractQValueList<String> {
    @Nonnull
    private static String _unify(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    public void addLanguage(@Nonnull String string, @Nonnegative double d) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Language");
        this.qvalueMap().put((Object)AcceptLanguageList._unify(string), (Object)new QValue(d));
    }

    @Nonnull
    public QValue getQValueOfLanguage(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Language");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptLanguageList._unify(string));
        if (qValue == null && (qValue = (QValue)this.qvalueMap().get((Object)"*")) == null) {
            return QValue.MIN_QVALUE;
        }
        return qValue;
    }

    public double getQualityOfLanguage(@Nonnull String string) {
        return this.getQValueOfLanguage(string).getQuality();
    }

    public boolean supportsLanguage(@Nonnull String string) {
        return this.getQValueOfLanguage(string).isAboveMinimumQuality();
    }

    public boolean explicitlySupportsLanguage(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Language");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptLanguageList._unify(string));
        return qValue != null && qValue.isAboveMinimumQuality();
    }
}

