/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.tls;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.http.tls.ETLSVersion;
import com.helger.http.tls.ITLSConfigurationMode;
import com.helger.http.tls.TLSConfigurationMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ETLSConfigurationMode_2020_02 implements IHasID<String>,
ITLSConfigurationMode
{
    MODERN("modern", new ETLSVersion[]{ETLSVersion.TLS_13}, new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256"}),
    INTERMEDIATE("intermediate", new ETLSVersion[]{ETLSVersion.TLS_13, ETLSVersion.TLS_12}, new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384"}),
    OLD("old", new ETLSVersion[]{ETLSVersion.TLS_13, ETLSVersion.TLS_12, ETLSVersion.TLS_11, ETLSVersion.TLS_10}, new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "SSL_CK_DES_192_EDE3_CBC_WITH_SHA"});

    private final String m_sID;
    private final TLSConfigurationMode m_aMode;

    private ETLSConfigurationMode_2020_02(@Nonnull @Nonempty String string2, ETLSVersion[] eTLSVersionArray, String[] stringArray) {
        this.m_sID = string2;
        this.m_aMode = new TLSConfigurationMode(eTLSVersionArray, stringArray);
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllCipherSuites() {
        return this.m_aMode.getAllCipherSuites();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public String[] getAllCipherSuitesAsArray() {
        return this.m_aMode.getAllCipherSuitesAsArray();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ETLSVersion> getAllTLSVersions() {
        return this.m_aMode.getAllTLSVersions();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTLSVersionIDs() {
        return this.m_aMode.getAllTLSVersionIDs();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public String[] getAllTLSVersionIDsAsArray() {
        return this.m_aMode.getAllTLSVersionIDsAsArray();
    }

    @Nullable
    public static ETLSConfigurationMode_2020_02 getFromIDOrNull(@Nullable String string) {
        return (ETLSConfigurationMode_2020_02)EnumHelper.getFromIDOrNull(ETLSConfigurationMode_2020_02.class, (Object)string);
    }
}

