/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mail.datasource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.string.ToStringGenerator;
import com.helger.mail.datasource.IExtendedDataSource;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ByteArrayDataSource
implements IExtendedDataSource {
    private final String m_sContentType;
    private byte[] m_aBytes;
    private final String m_sName;

    public ByteArrayDataSource(@Nonnull byte[] byArray, @Nullable String string, @Nullable String string2) {
        ValueEnforcer.notNull((Object)byArray, (String)"Bytes");
        this.m_aBytes = byArray;
        this.m_sContentType = string == null ? DEFAULT_CONTENT_TYPE.getAsString() : string;
        this.m_sName = string2;
    }

    @Nonnull
    @ReturnsMutableObject
    public byte[] directGetBytes() {
        return this.m_aBytes;
    }

    @Nonnull
    public NonBlockingByteArrayInputStream getInputStream() {
        return new NonBlockingByteArrayInputStream(this.m_aBytes);
    }

    @Nonnull
    public NonBlockingByteArrayOutputStream getOutputStream() throws IOException {
        return new WrappedOutputStream();
    }

    @Nonnull
    public String getContentType() {
        return this.m_sContentType;
    }

    @Nullable
    public String getName() {
        return this.m_sName;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("byte#", ArrayHelper.getSize((byte[])this.m_aBytes)).append("Name", (Object)this.m_sName).append("ContentType", (Object)this.m_sContentType).getToString();
    }

    static /* synthetic */ byte[] access$002(ByteArrayDataSource byteArrayDataSource, byte[] byArray) {
        byteArrayDataSource.m_aBytes = byArray;
        return byArray;
    }

    private class WrappedOutputStream
    extends NonBlockingByteArrayOutputStream {
        private WrappedOutputStream() {
        }

        public void close() {
            super.close();
            ByteArrayDataSource.access$002(ByteArrayDataSource.this, this.toByteArray());
        }
    }
}

