/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.settings;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringHelper;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IProxySettings
extends Serializable {
    @Nonnull
    public Proxy.Type getProxyType();

    @Nullable
    public String getProxyHost();

    public int getProxyPort();

    @Nullable
    public String getProxyUserName();

    default public boolean hasProxyUserName() {
        return StringHelper.hasText((String)this.getProxyUserName());
    }

    @Nullable
    public String getProxyPassword();

    default public boolean hasProxyPassword() {
        return this.getProxyPassword() != null;
    }

    default public boolean hasInetSocketAddress(@Nullable InetSocketAddress inetSocketAddress) {
        return inetSocketAddress != null && EqualsHelper.equals((Object)inetSocketAddress.getHostString(), (Object)this.getProxyHost()) && this.getProxyPort() == inetSocketAddress.getPort();
    }

    public boolean hasSocketAddress(@Nullable SocketAddress var1);

    @Nonnull
    default public Proxy getAsProxy() {
        return this.getAsProxy(true);
    }

    @Nonnull
    public Proxy getAsProxy(boolean var1);

    @Nullable
    default public PasswordAuthentication getAsPasswordAuthentication() {
        if (!this.hasProxyUserName()) {
            return null;
        }
        String string = this.getProxyPassword();
        return new PasswordAuthentication(this.getProxyUserName(), string == null ? new char[]{} : string.toCharArray());
    }
}

