/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.cookie;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.servlet.ServletHelper;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Immutable
public final class CookieHelper {
    public static final int DEFAULT_MAX_AGE_SECONDS = 2592000;
    private static final CookieHelper s_aInstance = new CookieHelper();

    private CookieHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, Cookie> getAllCookies(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        commonsLinkedHashMap.putAllMapped((Object[])ServletHelper.getRequestCookies(httpServletRequest), Cookie::getName, Function.identity());
        return commonsLinkedHashMap;
    }

    @Nullable
    public static Cookie getCookie(@Nonnull HttpServletRequest httpServletRequest, @Nonnull String string) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        ValueEnforcer.notNull((Object)string, (String)"CookieName");
        Cookie[] cookieArray = ServletHelper.getRequestCookies(httpServletRequest);
        if (cookieArray != null) {
            for (Cookie cookie : cookieArray) {
                if (!cookie.getName().equals(string)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static boolean containsCookie(@Nonnull HttpServletRequest httpServletRequest, @Nonnull String string) {
        return CookieHelper.getCookie(httpServletRequest, string) != null;
    }

    @Nonnull
    public static Cookie createCookie(@Nonnull String string, @Nullable String string2, String string3, boolean bl) {
        Cookie cookie = new Cookie(string, string2);
        cookie.setPath(string3);
        if (bl) {
            cookie.setMaxAge(-1);
        } else {
            cookie.setMaxAge(2592000);
        }
        return cookie;
    }

    @Nonnull
    public static Cookie createContextCookie(@Nonnull String string, @Nullable String string2, boolean bl) {
        String string3 = ServletContextPathHolder.getContextPath();
        return CookieHelper.createCookie(string, string2, StringHelper.hasText((String)string3) ? string3 : "/", bl);
    }

    public static void removeCookie(@Nonnull HttpServletResponse httpServletResponse, @Nonnull Cookie cookie) {
        ValueEnforcer.notNull((Object)httpServletResponse, (String)"HttpResponse");
        ValueEnforcer.notNull((Object)cookie, (String)"aCookie");
        cookie.setMaxAge(0);
        httpServletResponse.addCookie(cookie);
    }
}

