/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.IteratorHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.servlet.mock.MockHttpListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

@NotThreadSafe
public class MockHttpSession
implements HttpSession {
    public static final String SESSION_COOKIE_NAME = "JSESSIONID";
    private final String m_sID;
    private final long m_nCreationTime = System.currentTimeMillis();
    private int m_nMaxInactiveInterval = -1;
    private long m_nLastAccessedTime = System.currentTimeMillis();
    private final ServletContext m_aServletContext;
    private final ICommonsMap<String, Object> m_aAttributes = new CommonsHashMap();
    private boolean m_bInvalidated = false;
    private boolean m_bIsNew = true;

    public MockHttpSession() {
        this(null);
    }

    public MockHttpSession(@Nullable ServletContext servletContext) {
        this(servletContext, null);
    }

    public MockHttpSession(@Nullable ServletContext servletContext, @Nullable String string) {
        this.m_aServletContext = servletContext;
        this.m_sID = StringHelper.hasText((String)string) ? string : GlobalIDFactory.getNewStringID();
        HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
        for (HttpSessionListener httpSessionListener : MockHttpListener.getAllHttpSessionListeners()) {
            httpSessionListener.sessionCreated(httpSessionEvent);
        }
    }

    public long getCreationTime() {
        return this.m_nCreationTime;
    }

    @Nonnull
    @Nonempty
    public String getId() {
        return this.m_sID;
    }

    public void doAccess() {
        this.m_nLastAccessedTime = System.currentTimeMillis();
        this.m_bIsNew = false;
    }

    public long getLastAccessedTime() {
        return this.m_nLastAccessedTime;
    }

    @Nonnull
    public ServletContext getServletContext() {
        if (this.m_aServletContext == null) {
            throw new IllegalStateException("No servlet context present!");
        }
        return this.m_aServletContext;
    }

    public void setMaxInactiveInterval(int n) {
        this.m_nMaxInactiveInterval = n;
    }

    public int getMaxInactiveInterval() {
        return this.m_nMaxInactiveInterval;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException("getSessionContext");
    }

    @Nullable
    public Object getAttribute(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        return this.m_aAttributes.get((Object)string);
    }

    @Deprecated
    public Object getValue(@Nonnull String string) {
        return this.getAttribute(string);
    }

    @Nonnull
    public Enumeration<String> getAttributeNames() {
        return IteratorHelper.getEnumeration((Iterable)this.m_aAttributes.keySet());
    }

    @Deprecated
    @Nonnull
    public String[] getValueNames() {
        return (String[])ArrayHelper.newArray((Collection)this.m_aAttributes.keySet(), String.class);
    }

    public void setAttribute(@Nonnull String string, @Nullable Object object) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        if (object != null) {
            this.m_aAttributes.put((Object)string, object);
            if (object instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string, object));
            }
        } else {
            this.removeAttribute(string);
        }
    }

    @Deprecated
    public void putValue(@Nonnull String string, @Nullable Object object) {
        this.setAttribute(string, object);
    }

    public void removeAttribute(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        Object object = this.m_aAttributes.remove((Object)string);
        if (object instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string, object));
        }
    }

    @Deprecated
    public void removeValue(@Nonnull String string) {
        this.removeAttribute(string);
    }

    public void clearAttributes() {
        for (Map.Entry entry : this.m_aAttributes.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (!(v instanceof HttpSessionBindingListener)) continue;
            ((HttpSessionBindingListener)v).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string, v));
        }
        this.m_aAttributes.clear();
    }

    public void invalidate() {
        if (this.m_bInvalidated) {
            throw new IllegalStateException("Session scope '" + this.getId() + "' already invalidated!");
        }
        this.m_bInvalidated = true;
        HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
        for (HttpSessionListener httpSessionListener : MockHttpListener.getAllHttpSessionListeners()) {
            httpSessionListener.sessionDestroyed(httpSessionEvent);
        }
        this.clearAttributes();
    }

    public boolean isInvalid() {
        return this.m_bInvalidated;
    }

    public void setNew(boolean bl) {
        this.m_bIsNew = bl;
    }

    public boolean isNew() {
        return this.m_bIsNew;
    }

    @Nonnull
    public Serializable serializeState() {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (Map.Entry entry : this.m_aAttributes.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Serializable) {
                commonsHashMap.put((Object)string, v);
                continue;
            }
            if (!(v instanceof HttpSessionBindingListener)) continue;
            ((HttpSessionBindingListener)v).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string, v));
        }
        this.m_aAttributes.clear();
        return commonsHashMap;
    }

    public void deserializeState(@Nonnull Serializable serializable) {
        if (!(serializable instanceof Map)) {
            throw new IllegalArgumentException("Serialized state needs to be of type [java.util.Map]");
        }
        this.m_aAttributes.putAll((Map)((Object)serializable));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("creationTime", this.m_nCreationTime).append("maxInactiveInterval", this.m_nMaxInactiveInterval).append("lastAccessedTime", this.m_nLastAccessedTime).appendIfNotNull("servletContext", this.m_aServletContext == null ? null : this.m_aServletContext.getServerInfo()).append("attributes", this.m_aAttributes).append("isInvalidated", this.m_bInvalidated).append("isNew", this.m_bIsNew).getToString();
    }
}

