/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent.browser;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.util.XMLListHandler;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MobileBrowserManager {
    private static final ICommonsSet<String> s_aSet = new CommonsHashSet();
    private static final MobileBrowserManager s_aInstance;

    private MobileBrowserManager() {
    }

    @Nonnull
    private static String _unify(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    private static void _readList(@Nonnull String string) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (XMLListHandler.readList((IHasInputStream)new ClassPathResource(string), (Collection)commonsArrayList).isFailure()) {
            throw new IllegalStateException("Failed to read " + string);
        }
        s_aSet.addAllMapped((Iterable)commonsArrayList, MobileBrowserManager::_unify);
    }

    @Nullable
    public static String getFromUserAgent(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        String string2 = MobileBrowserManager._unify(string);
        return (String)s_aSet.findFirst(string2::contains);
    }

    static {
        MobileBrowserManager._readList("codelists/mobileuseragents.xml");
        s_aInstance = new MobileBrowserManager();
    }
}

