/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent.uaprofile;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.base64.Base64;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import com.helger.security.messagedigest.MessageDigestValue;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class UAProfileDiff
implements Serializable {
    public static final int EXPECTED_MD5_DIGEST_BYTES = 16;
    private static final Logger LOGGER = LoggerFactory.getLogger(UAProfileDiff.class);
    private final String m_sData;
    private final byte[] m_aMD5Digest;
    private final IMicroDocument m_aDocument;

    public UAProfileDiff(@Nonnull @Nonempty String string, @Nullable byte[] byArray) {
        byte[] byArray2;
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Data");
        if (byArray != null && byArray.length != 16) {
            throw new IllegalArgumentException("invalid MD5 digest length: " + byArray.length);
        }
        this.m_sData = string;
        this.m_aMD5Digest = ArrayHelper.getCopy((byte[])byArray);
        if (this.m_aMD5Digest != null && !Arrays.equals(this.m_aMD5Digest, byArray2 = MessageDigestValue.create((byte[])string.getBytes(StandardCharsets.UTF_8), (EMessageDigestAlgorithm)EMessageDigestAlgorithm.MD5).bytes()) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("MD5 digest mismatch of profile diff data! Expected '" + Base64.encodeBytes((byte[])byArray2) + "' but have '" + Base64.encodeBytes((byte[])this.m_aMD5Digest) + "'");
        }
        this.m_aDocument = MicroReader.readMicroXML((String)string);
        if (this.m_aDocument == null && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Failed to parse profile diff data as XML '" + string + "'");
        }
    }

    @Nonnull
    @Nonempty
    public String getData() {
        return this.m_sData;
    }

    @Nullable
    @ReturnsMutableCopy
    public byte[] getMD5Digest() {
        return ArrayHelper.getCopy((byte[])this.m_aMD5Digest);
    }

    @Nullable
    public IMicroDocument getDocument() {
        return this.m_aDocument;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        UAProfileDiff uAProfileDiff = (UAProfileDiff)object;
        return this.m_sData.equals(uAProfileDiff.m_sData) && EqualsHelper.equals((Object)this.m_aMD5Digest, (Object)uAProfileDiff.m_aMD5Digest);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sData).append(this.m_aMD5Digest).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("data", (Object)this.m_sData).appendIfNotNull("digest", (Object)this.m_aMD5Digest).appendIfNotNull("document", (Object)this.m_aDocument).getToString();
    }
}

