/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.StringHelper;
import com.helger.useragent.IUserAgent;
import com.helger.useragent.UserAgentDecryptor;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class UserAgentDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAgentDatabase.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsSet<String> UNIQUE_USER_AGENTS = new CommonsHashSet();
    @GuardedBy(value="RW_LOCK")
    private static Consumer<? super IUserAgent> s_aNewUserAgentCallback;
    private static final UserAgentDatabase INSTANCE;

    private UserAgentDatabase() {
    }

    public static void setUserAgentCallback(@Nullable Consumer<? super IUserAgent> consumer) {
        RW_LOCK.writeLocked(() -> {
            s_aNewUserAgentCallback = consumer;
        });
    }

    @Nullable
    public static IUserAgent getParsedUserAgent(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        IUserAgent iUserAgent = UserAgentDecryptor.decryptUserAgentString(string);
        boolean bl = RW_LOCK.writeLockedBoolean(() -> UNIQUE_USER_AGENTS.add((Object)string));
        if (bl) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found new UserAgent '" + string + "'");
            }
            RW_LOCK.readLocked(() -> {
                if (s_aNewUserAgentCallback != null) {
                    s_aNewUserAgentCallback.accept(iUserAgent);
                }
            });
        }
        return iUserAgent;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllUniqueUserAgents() {
        return (ICommonsSet)RW_LOCK.readLockedGet(() -> UNIQUE_USER_AGENTS.getClone());
    }

    static {
        INSTANCE = new UserAgentDatabase();
    }
}

