/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent.browser;

import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.version.Version;
import com.helger.useragent.browser.BrowserInfo;
import com.helger.useragent.browser.EBrowserText;
import com.helger.useragent.browser.EBrowserType;
import java.util.Locale;
import javax.annotation.Nonnull;

public class BrowserInfoIE
extends BrowserInfo {
    public static final BrowserInfoIE IS_IT_NOT_IE = new BrowserInfoIE();
    private final boolean m_bIsIECompatibilityMode;

    private BrowserInfoIE() {
        this.m_bIsIECompatibilityMode = false;
    }

    public BrowserInfoIE(@Nonnull Version version, boolean bl) {
        super(EBrowserType.IE, version);
        this.m_bIsIECompatibilityMode = bl;
    }

    public boolean isIECompatibilityMode() {
        return this.m_bIsIECompatibilityMode;
    }

    @Override
    public String getDisplayText(@Nonnull Locale locale) {
        return super.getDisplayText(locale) + (this.isIECompatibilityMode() ? EBrowserText.IE_COMPATIBILITY_MODE.getDisplayText(locale) : "");
    }

    @Override
    public String toString() {
        if (this.isItNot()) {
            return new ToStringGenerator(null).append("isIt", (Object)"not").getToString();
        }
        return ToStringGenerator.getDerived((String)super.toString()).append("ieCompatibilityMode", this.m_bIsIECompatibilityMode).getToString();
    }
}

