/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent.uaprofile;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsSortedMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.useragent.uaprofile.UAProfileDiff;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class UAProfile {
    private static final Logger LOGGER = LoggerFactory.getLogger(UAProfile.class);
    public static final UAProfile EMPTY = new UAProfile();
    private final String m_sProfileUrl;
    private final ICommonsSortedMap<Integer, UAProfileDiff> m_aProfileDiffData;

    private UAProfile() {
        this.m_sProfileUrl = null;
        this.m_aProfileDiffData = null;
    }

    public UAProfile(@Nullable List<String> list, @Nullable Map<Integer, UAProfileDiff> map) {
        int n = CollectionHelper.getSize(list);
        int n2 = CollectionHelper.getSize(map);
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException("Neither profile nor diff data found!");
        }
        if (n > 1 && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Found more than one profile URL: " + list);
        }
        this.m_sProfileUrl = (String)CollectionHelper.getFirstElement(list);
        this.m_aProfileDiffData = CollectionHelper.isEmpty(map) ? null : new CommonsTreeMap(map);
    }

    @Nullable
    public String getProfileURL() {
        return this.m_sProfileUrl;
    }

    @Nonnegative
    public int getDiffCount() {
        return CollectionHelper.getSize(this.m_aProfileDiffData);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSortedMap<Integer, UAProfileDiff> getProfileDiffData() {
        return new CommonsTreeMap(this.m_aProfileDiffData);
    }

    public boolean isSet() {
        return this.m_sProfileUrl != null || this.m_aProfileDiffData != null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        UAProfile uAProfile = (UAProfile)object;
        return EqualsHelper.equals((Object)this.m_sProfileUrl, (Object)uAProfile.m_sProfileUrl) && EqualsHelper.equals(this.m_aProfileDiffData, uAProfile.m_aProfileDiffData);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sProfileUrl).append(this.m_aProfileDiffData).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("profileUrl", (Object)this.m_sProfileUrl).appendIfNotNull("profileDiff", this.m_aProfileDiffData).getToString();
    }
}

