/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload.parse;

import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.state.ICloseable;
import com.helger.web.fileupload.IFileItemHeaders;
import com.helger.web.fileupload.IFileItemStream;
import com.helger.web.fileupload.exception.FileSizeLimitExceededException;
import com.helger.web.fileupload.exception.FileUploadIOException;
import com.helger.web.fileupload.io.AbstractLimitedInputStream;
import com.helger.web.fileupload.io.FileUploadHelper;
import com.helger.web.multipart.MultipartItemSkippedException;
import com.helger.web.multipart.MultipartStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileItemStream
implements IFileItemStream,
Closeable {
    private final String m_sContentType;
    private final String m_sFieldName;
    private final String m_sName;
    private final boolean m_bFormField;
    @WillCloseWhenClosed
    private final InputStream m_aIS;
    private IFileItemHeaders m_aHeaders;

    FileItemStream(@Nullable String string, String string2, @Nullable String string3, boolean bl, @CheckForSigned long l, @Nonnull MultipartStream multipartStream, long l2) throws IOException {
        this.m_sName = string;
        this.m_sFieldName = string2;
        this.m_sContentType = string3;
        this.m_bFormField = bl;
        if (l2 > 0L) {
            if (l >= 0L && l > l2) {
                FileSizeLimitExceededException fileSizeLimitExceededException = new FileSizeLimitExceededException("The field " + this.m_sFieldName + " exceeds its maximum permitted size of " + l2 + " bytes.", l, l2, string2, string);
                throw new FileUploadIOException(fileSizeLimitExceededException);
            }
            final MultipartStream.MultipartItemInputStream multipartItemInputStream = multipartStream.createInputStream();
            this.m_aIS = new AbstractLimitedInputStream(multipartItemInputStream, l2){

                @Override
                protected void onLimitExceeded(long l, long l2) throws IOException {
                    multipartItemInputStream.close(true);
                    FileSizeLimitExceededException fileSizeLimitExceededException = new FileSizeLimitExceededException("The field " + FileItemStream.this.m_sFieldName + " exceeds its maximum permitted size of " + l + " bytes.", l2, l, FileItemStream.this.m_sFieldName, FileItemStream.this.m_sFieldName);
                    throw new FileUploadIOException(fileSizeLimitExceededException);
                }
            };
        } else {
            MultipartStream.MultipartItemInputStream multipartItemInputStream = multipartStream.createInputStream();
            this.m_aIS = multipartItemInputStream;
        }
    }

    @Override
    public void close() throws IOException {
        this.m_aIS.close();
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.m_sContentType;
    }

    @Override
    public String getFieldName() {
        return this.m_sFieldName;
    }

    @Override
    @Nullable
    public String getName() {
        return FileUploadHelper.checkFileName(this.m_sName);
    }

    @Override
    @Nullable
    public String getNameSecure() {
        return FilenameHelper.getAsSecureValidFilename((String)this.m_sName);
    }

    @Override
    @Nullable
    public String getNameUnchecked() {
        return this.m_sName;
    }

    @Override
    public boolean isFormField() {
        return this.m_bFormField;
    }

    @Override
    @Nonnull
    public InputStream openStream() throws IOException {
        if (this.m_aIS instanceof ICloseable && ((ICloseable)this.m_aIS).isClosed()) {
            throw new MultipartItemSkippedException();
        }
        return this.m_aIS;
    }

    @Override
    @Nullable
    public IFileItemHeaders getHeaders() {
        return this.m_aHeaders;
    }

    @Override
    public void setHeaders(@Nullable IFileItemHeaders iFileItemHeaders) {
        this.m_aHeaders = iFileItemHeaders;
    }
}

