/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.mgr;

import com.helger.servlet.mock.MockHttpServletResponse;
import com.helger.servlet.mock.OfflineHttpServletRequest;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebScoped
implements AutoCloseable {
    private IRequestWebScope m_aRequestScope;

    public WebScoped() {
        this((HttpServletRequest)new OfflineHttpServletRequest(WebScopeManager.getGlobalScope().getServletContext(), false));
    }

    public WebScoped(@Nonnull HttpServletRequest httpServletRequest) {
        this(httpServletRequest, (HttpServletResponse)new MockHttpServletResponse());
    }

    public WebScoped(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) {
        this.m_aRequestScope = WebScopeManager.onRequestBegin(httpServletRequest, httpServletResponse);
    }

    @Nonnull
    public IRequestWebScope getRequestScope() {
        if (this.m_aRequestScope == null) {
            throw new IllegalStateException("No request scope present!");
        }
        return this.m_aRequestScope;
    }

    @Override
    public void close() {
        this.m_aRequestScope = null;
        WebScopeManager.onRequestEnd();
    }
}

