/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.mock;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.servlet.mock.MockHttpListener;
import com.helger.servlet.mock.MockHttpServletRequest;
import com.helger.servlet.mock.MockServletContext;
import com.helger.servlet.mock.MockServletPool;
import com.helger.web.scope.mock.MockServletRequestListenerScopeAware;
import com.helger.web.scope.mock.WebScopeAwareTestSetup;
import com.helger.web.servlets.scope.WebScopeListener;
import java.util.EventListener;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.http.HttpSession;
import org.junit.rules.ExternalResource;

@NotThreadSafe
public class WebScopeTestRule
extends ExternalResource {
    public static final String MOCK_CONTEXT_PATH = "/MockContext";
    private String m_sContextPath = "/MockContext";
    private ICommonsMap<String, String> m_aServletContextInitParameters;
    private MockServletContext m_aServletContext;
    private MockHttpServletRequest m_aRequest;

    public WebScopeTestRule() {
        this(null);
    }

    public WebScopeTestRule(@Nullable ICommonsMap<String, String> iCommonsMap) {
        this.m_aServletContextInitParameters = iCommonsMap;
    }

    @Nonnull
    public final WebScopeTestRule setContextPath(@Nullable String string) {
        this.m_sContextPath = string;
        return this;
    }

    @Nullable
    public final String getContextPath() {
        return this.m_sContextPath;
    }

    @Nonnull
    public final WebScopeTestRule setServletContextInitParameters(@Nullable ICommonsMap<String, String> iCommonsMap) {
        this.m_aServletContextInitParameters = iCommonsMap;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsMap<String, String> getServletContextInitParameters() {
        return new CommonsHashMap(this.m_aServletContextInitParameters);
    }

    @OverrideOnDemand
    protected void initListener() {
        MockHttpListener.removeAllDefaultListeners();
        MockHttpListener.addDefaultListener((EventListener)((Object)new WebScopeListener()));
        MockHttpListener.addDefaultListener((EventListener)((Object)new MockServletRequestListenerScopeAware()));
        MockHttpListener.setCurrentToDefault();
    }

    @Nonnull
    @OverrideOnDemand
    protected MockServletContext createMockServletContext(@Nullable String string, @Nullable Map<String, String> map) {
        return WebScopeAwareTestSetup.createDefaultMockServletContext(string, map);
    }

    @Nullable
    @OverrideOnDemand
    protected MockHttpServletRequest createMockRequest(@Nonnull MockServletContext mockServletContext) {
        return WebScopeAwareTestSetup.createDefaultMockRequest(mockServletContext);
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public void before() {
        this.initListener();
        this.m_aServletContext = this.createMockServletContext(this.m_sContextPath, (Map<String, String>)this.m_aServletContextInitParameters);
        if (this.m_aServletContext == null) {
            throw new IllegalStateException("Failed to created MockServletContext");
        }
        this.m_aRequest = this.createMockRequest(this.m_aServletContext);
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public void after() {
        WebScopeAwareTestSetup.shutdownWebScopeTests(this.m_aRequest, this.m_aServletContext);
        this.m_aRequest = null;
        this.m_aServletContext = null;
    }

    @Nullable
    public final MockServletContext getServletContext() {
        return this.m_aServletContext;
    }

    @Nullable
    public final MockServletPool getServletPool() {
        return this.m_aServletContext == null ? null : this.m_aServletContext.getServletPool();
    }

    @Nullable
    public final MockHttpServletRequest getRequest() {
        return this.m_aRequest;
    }

    @Nullable
    public final HttpSession getSession(boolean bl) {
        return this.m_aRequest == null ? null : this.m_aRequest.getSession(bl);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("contextPath", (Object)this.m_sContextPath).appendIfNotNull("servletContextInitParams", this.m_aServletContextInitParameters).append("servletContext", (Object)this.m_aServletContext).appendIfNotNull("request", (Object)this.m_aRequest).getToString();
    }
}

