/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.web.scope.util.AbstractRequestFieldData;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RequestFieldDataMultiValue
extends AbstractRequestFieldData {
    private final ICommonsList<String> m_aDefaultValues;

    public RequestFieldDataMultiValue(@Nonnull RequestFieldDataMultiValue requestFieldDataMultiValue) {
        this(requestFieldDataMultiValue.getFieldName(), (Collection<String>)requestFieldDataMultiValue.m_aDefaultValues);
    }

    public RequestFieldDataMultiValue(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public RequestFieldDataMultiValue(@Nonnull @Nonempty String string, @Nullable Collection<String> collection) {
        super(string);
        this.m_aDefaultValues = new CommonsArrayList(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    @OverrideOnDemand
    public ICommonsList<String> getDefaultValues() {
        return (ICommonsList)this.m_aDefaultValues.getClone();
    }

    @Nullable
    protected final ICommonsList<String> getRequestValuesWithoutDefault() {
        return RequestFieldDataMultiValue.getParams().getAsStringList(this.getFieldName(), null);
    }

    @Nonnull
    public final ICommonsList<String> getRequestValues() {
        return RequestFieldDataMultiValue.getParams().getAsStringList(this.getFieldName(), this.getDefaultValues());
    }

    public final boolean hasRequestValues(@Nonnull Collection<String> collection) {
        ValueEnforcer.notNull(collection, (String)"ExpectedValues");
        return EqualsHelper.equalsCollection(collection, this.getRequestValues());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RequestFieldDataMultiValue requestFieldDataMultiValue = (RequestFieldDataMultiValue)object;
        return this.m_aDefaultValues.equals(requestFieldDataMultiValue.m_aDefaultValues);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aDefaultValues).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("DefaultValues", this.m_aDefaultValues).getToString();
    }
}

