/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload.parse;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.string.StringParser;
import com.helger.servlet.request.RequestHelper;
import com.helger.web.fileupload.IFileItem;
import com.helger.web.fileupload.IFileItemFactory;
import com.helger.web.fileupload.IFileItemHeaders;
import com.helger.web.fileupload.IFileItemHeadersSupport;
import com.helger.web.fileupload.IFileItemIterator;
import com.helger.web.fileupload.IFileItemStream;
import com.helger.web.fileupload.IRequestContext;
import com.helger.web.fileupload.exception.FileUploadException;
import com.helger.web.fileupload.exception.FileUploadIOException;
import com.helger.web.fileupload.exception.IOFileUploadException;
import com.helger.web.fileupload.exception.InvalidContentTypeException;
import com.helger.web.fileupload.exception.SizeLimitExceededException;
import com.helger.web.fileupload.io.AbstractLimitedInputStream;
import com.helger.web.fileupload.parse.FileItemHeaders;
import com.helger.web.fileupload.parse.FileItemStream;
import com.helger.web.fileupload.parse.ParameterParser;
import com.helger.web.multipart.MultipartProgressNotifier;
import com.helger.web.multipart.MultipartStream;
import com.helger.web.progress.IProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileUploadBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileUploadBase.class);
    private long m_nSizeMax = -1L;
    private long m_nFileSizeMax = -1L;
    private String m_sHeaderEncoding;
    private IProgressListener m_aListener;

    @Nonnull
    public abstract IFileItemFactory getFileItemFactory();

    @CheckForSigned
    public long getSizeMax() {
        return this.m_nSizeMax;
    }

    public void setSizeMax(long l) {
        this.m_nSizeMax = l;
    }

    @CheckForSigned
    public long getFileSizeMax() {
        return this.m_nFileSizeMax;
    }

    public void setFileSizeMax(long l) {
        this.m_nFileSizeMax = l;
    }

    @Nullable
    public String getHeaderEncoding() {
        return this.m_sHeaderEncoding;
    }

    public void setHeaderEncoding(@Nullable String string) {
        this.m_sHeaderEncoding = string;
    }

    @Nullable
    public IProgressListener getProgressListener() {
        return this.m_aListener;
    }

    public void setProgressListener(@Nullable IProgressListener iProgressListener) {
        this.m_aListener = iProgressListener;
    }

    @Nonnull
    public IFileItemIterator getItemIterator(@Nonnull IRequestContext iRequestContext) throws FileUploadException, IOException {
        return new FileItemIterator(iRequestContext);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IFileItem> parseRequest(@Nonnull IRequestContext iRequestContext) throws FileUploadException {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        boolean bl = false;
        try {
            IFileItemStream iFileItemStream;
            IFileItemIterator iFileItemIterator = this.getItemIterator(iRequestContext);
            IFileItemFactory iFileItemFactory = this.getFileItemFactory();
            if (iFileItemFactory == null) {
                throw new IllegalStateException("No FileItemFactory has been set.");
            }
            while (iFileItemIterator.hasNext()) {
                Object object;
                iFileItemStream = iFileItemIterator.next();
                IFileItem iFileItem = iFileItemFactory.createItem(iFileItemStream.getFieldName(), iFileItemStream.getContentType(), iFileItemStream.isFormField(), iFileItemStream.getNameUnchecked());
                commonsArrayList.add((Object)iFileItem);
                try {
                    object = iFileItemStream.openStream();
                    Throwable throwable = null;
                    try (OutputStream outputStream = iFileItem.getOutputStream();){
                        int n;
                        byte[] byArray = new byte[8192];
                        while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) > -1) {
                            outputStream.write(byArray, 0, n);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((InputStream)object).close();
                            }
                        }
                    }
                }
                catch (FileUploadIOException fileUploadIOException) {
                    throw (FileUploadException)fileUploadIOException.getCause();
                }
                catch (IOException iOException) {
                    throw new IOFileUploadException("Processing of multipart/form-data request failed. " + iOException.getMessage(), iOException);
                }
                if (!(iFileItem instanceof IFileItemHeadersSupport)) continue;
                object = iFileItemStream.getHeaders();
                ((IFileItemHeadersSupport)((Object)iFileItem)).setHeaders((IFileItemHeaders)object);
            }
            bl = true;
            iFileItemStream = commonsArrayList;
            return iFileItemStream;
        }
        catch (FileUploadIOException fileUploadIOException) {
            throw (FileUploadException)fileUploadIOException.getCause();
        }
        catch (IOException iOException) {
            throw new FileUploadException(iOException.getMessage(), iOException);
        }
        finally {
            if (!bl) {
                for (IFileItem iFileItem : commonsArrayList) {
                    try {
                        iFileItem.delete();
                    }
                    catch (Exception exception) {
                        if (!LOGGER.isErrorEnabled()) continue;
                        LOGGER.error("Failed to delete fileItem " + iFileItem, (Throwable)exception);
                    }
                }
            }
        }
    }

    @Nullable
    protected byte[] getBoundary(@Nonnull String string) {
        ICommonsMap<String, String> iCommonsMap = new ParameterParser().setLowerCaseNames(true).parse(string, new char[]{';', ','});
        String string2 = (String)iCommonsMap.get((Object)"boundary");
        if (string2 == null) {
            return null;
        }
        return string2.getBytes(StandardCharsets.ISO_8859_1);
    }

    @Nullable
    protected String getFileName(@Nonnull IFileItemHeaders iFileItemHeaders) {
        return AbstractFileUploadBase._getFilename(iFileItemHeaders.getHeaderContentDisposition());
    }

    @Nullable
    private static String _getFilename(@Nullable String string) {
        ICommonsMap<String, String> iCommonsMap;
        String string2;
        String string3 = null;
        if (string != null && ((string2 = string.toLowerCase(Locale.US)).startsWith("form-data") || string2.startsWith("attachment")) && (iCommonsMap = new ParameterParser().setLowerCaseNames(true).parse(string, ';')).containsKey((Object)"filename")) {
            string3 = (String)iCommonsMap.get((Object)"filename");
            string3 = string3 != null ? string3.trim() : "";
        }
        return string3;
    }

    @Nullable
    protected String getFieldName(@Nonnull IFileItemHeaders iFileItemHeaders) {
        return AbstractFileUploadBase._getFieldName(iFileItemHeaders.getHeaderContentDisposition());
    }

    @Nullable
    private static String _getFieldName(@Nullable String string) {
        ICommonsMap<String, String> iCommonsMap;
        String string2 = null;
        if (string != null && string.toLowerCase(Locale.US).startsWith("form-data") && (string2 = (String)(iCommonsMap = new ParameterParser().setLowerCaseNames(true).parse(string, ';')).get((Object)"name")) != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    @Nonnull
    protected IFileItemHeaders getParsedHeaders(@Nonnull String string) {
        int n;
        int n2 = string.length();
        FileItemHeaders fileItemHeaders = this.createFileItemHeaders();
        int n3 = 0;
        while (n3 != (n = AbstractFileUploadBase._parseEndOfLine(string, n3))) {
            StringBuilder stringBuilder = new StringBuilder(string.substring(n3, n));
            n3 = n + 2;
            while (n3 < n2) {
                char c;
                int n4;
                for (n4 = n3; n4 < n2 && ((c = string.charAt(n4)) == ' ' || c == '\t'); ++n4) {
                }
                if (n4 == n3) break;
                n = AbstractFileUploadBase._parseEndOfLine(string, n4);
                stringBuilder.append(' ').append(string.substring(n4, n));
                n3 = n + 2;
            }
            AbstractFileUploadBase._parseHeaderLine(fileItemHeaders, stringBuilder.toString());
        }
        return fileItemHeaders;
    }

    @Nonnull
    protected FileItemHeaders createFileItemHeaders() {
        return new FileItemHeaders();
    }

    private static int _parseEndOfLine(@Nonnull String string, int n) {
        int n2 = n;
        while (true) {
            int n3;
            if ((n3 = string.indexOf(13, n2)) == -1 || n3 + 1 >= string.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (string.charAt(n3 + 1) == '\n') {
                return n3;
            }
            n2 = n3 + 1;
        }
    }

    private static void _parseHeaderLine(@Nonnull FileItemHeaders fileItemHeaders, @Nonnull String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Found malformed HTTP header line '" + string + "'");
            }
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(string.indexOf(58) + 1).trim();
        fileItemHeaders.addHeader(string2, string3);
    }

    private final class FileItemIterator
    implements IFileItemIterator {
        private final MultipartStream m_aMulti;
        private final MultipartProgressNotifier m_aNotifier;
        private final byte[] m_aBoundary;
        private FileItemStream m_aCurrentItem;
        private String m_sCurrentFieldName;
        private boolean m_bSkipPreamble;
        private boolean m_bItemValid;
        private boolean m_bEOF;

        FileItemIterator(IRequestContext iRequestContext) throws FileUploadException, IOException {
            String string;
            ValueEnforcer.notNull((Object)iRequestContext, (String)"RequestContext");
            String string2 = iRequestContext.getContentType();
            if (!RequestHelper.isMultipartContent((String)string2)) {
                throw new InvalidContentTypeException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content-type header is '" + string2 + "'");
            }
            Object object = iRequestContext.getInputStream();
            long l = iRequestContext.getContentLength();
            if (AbstractFileUploadBase.this.m_nSizeMax >= 0L) {
                if (l < 0L) {
                    object = new AbstractLimitedInputStream((InputStream)object, AbstractFileUploadBase.this.m_nSizeMax){

                        @Override
                        protected void onLimitExceeded(long l, long l2) throws IOException {
                            SizeLimitExceededException sizeLimitExceededException = new SizeLimitExceededException("the request was rejected because its size (" + l2 + ") exceeds the configured maximum (" + l + ")", l2, l);
                            throw new FileUploadIOException(sizeLimitExceededException);
                        }
                    };
                } else if (AbstractFileUploadBase.this.m_nSizeMax >= 0L && l > AbstractFileUploadBase.this.m_nSizeMax) {
                    throw new SizeLimitExceededException("the request was rejected because its size (" + l + ") exceeds the configured maximum (" + AbstractFileUploadBase.this.m_nSizeMax + ")", l, AbstractFileUploadBase.this.m_nSizeMax);
                }
            }
            if ((string = AbstractFileUploadBase.this.m_sHeaderEncoding) == null) {
                string = iRequestContext.getCharacterEncoding();
            }
            this.m_aBoundary = AbstractFileUploadBase.this.getBoundary(string2);
            if (this.m_aBoundary == null) {
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            this.m_aNotifier = new MultipartProgressNotifier(AbstractFileUploadBase.this.m_aListener, l);
            this.m_aMulti = new MultipartStream((InputStream)object, this.m_aBoundary, this.m_aNotifier);
            this.m_aMulti.setHeaderEncoding(string);
            this.m_bSkipPreamble = true;
            this._findNextItem();
        }

        private boolean _findNextItem() throws IOException {
            if (this.m_bEOF) {
                return false;
            }
            if (this.m_aCurrentItem != null) {
                this.m_aCurrentItem.close();
                this.m_aCurrentItem = null;
            }
            while (true) {
                String string;
                boolean bl;
                if (!(bl = this.m_bSkipPreamble ? this.m_aMulti.skipPreamble() : this.m_aMulti.readBoundary())) {
                    if (this.m_sCurrentFieldName == null) {
                        this.m_bEOF = true;
                        return false;
                    }
                    this.m_aMulti.setBoundary(this.m_aBoundary);
                    this.m_sCurrentFieldName = null;
                    continue;
                }
                IFileItemHeaders iFileItemHeaders = AbstractFileUploadBase.this.getParsedHeaders(this.m_aMulti.readHeaders());
                String string2 = iFileItemHeaders.getHeaderContentType();
                if (this.m_sCurrentFieldName == null) {
                    string = AbstractFileUploadBase.this.getFieldName(iFileItemHeaders);
                    if (string != null) {
                        Object object;
                        if (string2 != null && string2.toLowerCase(Locale.US).startsWith("multipart/mixed")) {
                            this.m_sCurrentFieldName = string;
                            object = AbstractFileUploadBase.this.getBoundary(string2);
                            this.m_aMulti.setBoundary((byte[])object);
                            this.m_bSkipPreamble = true;
                            continue;
                        }
                        this.m_aCurrentItem = new FileItemStream((String)object, string, string2, (object = AbstractFileUploadBase.this.getFileName(iFileItemHeaders)) == null, this._getContentLength(iFileItemHeaders), this.m_aMulti, AbstractFileUploadBase.this.m_nFileSizeMax);
                        this.m_aNotifier.onNextFileItem();
                        this.m_bItemValid = true;
                        return true;
                    }
                } else {
                    string = AbstractFileUploadBase.this.getFileName(iFileItemHeaders);
                    if (string != null) {
                        this.m_aCurrentItem = new FileItemStream(string, this.m_sCurrentFieldName, string2, false, this._getContentLength(iFileItemHeaders), this.m_aMulti, AbstractFileUploadBase.this.m_nFileSizeMax);
                        this.m_aNotifier.onNextFileItem();
                        this.m_bItemValid = true;
                        return true;
                    }
                }
                this.m_aMulti.discardBodyData();
            }
        }

        private long _getContentLength(@Nonnull IFileItemHeaders iFileItemHeaders) {
            return StringParser.parseLong((String)iFileItemHeaders.getHeaderContentLength(), (long)-1L);
        }

        @Override
        public boolean hasNext() throws FileUploadException, IOException {
            if (this.m_bEOF) {
                return false;
            }
            if (this.m_bItemValid) {
                return true;
            }
            return this._findNextItem();
        }

        @Override
        @Nonnull
        public IFileItemStream next() throws FileUploadException, IOException {
            if (this.m_bEOF || !this.m_bItemValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.m_bItemValid = false;
            return this.m_aCurrentItem;
        }
    }
}

