/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.web.scope.util.AbstractRequestFieldData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RequestFieldData
extends AbstractRequestFieldData {
    private final String m_sDefaultValue;

    public RequestFieldData(@Nonnull RequestFieldData requestFieldData) {
        this(requestFieldData.getFieldName(), requestFieldData.m_sDefaultValue);
    }

    public RequestFieldData(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public RequestFieldData(@Nonnull @Nonempty String string, @Nullable String string2) {
        super(string);
        this.m_sDefaultValue = string2 == null ? "" : string2;
    }

    @Nonnull
    @OverrideOnDemand
    public String getDefaultValue() {
        return this.m_sDefaultValue;
    }

    @Nullable
    protected final String getRequestValueWithoutDefault() {
        return RequestFieldData.getParams().getAsString(this.getFieldName(), null);
    }

    @Nonnull
    public final String getRequestValue() {
        return RequestFieldData.getParams().getAsString(this.getFieldName(), this.getDefaultValue());
    }

    public final boolean hasRequestValue(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"ExpectedValue");
        return string.equals(this.getRequestValue());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RequestFieldData requestFieldData = (RequestFieldData)object;
        return this.m_sDefaultValue.equals(requestFieldData.m_sDefaultValue);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sDefaultValue).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("DefaultValue", (Object)this.m_sDefaultValue).getToString();
    }
}

