/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.state.EContinue;
import com.helger.commons.url.ISimpleURL;
import com.helger.http.EHttpVersion;
import com.helger.servlet.response.EXFrameOptionType;
import com.helger.xservlet.filter.IXServletLowLevelFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XServletFilterSecurityXFrameOptions
implements IXServletLowLevelFilter {
    private final String m_sHeaderValue;

    public XServletFilterSecurityXFrameOptions(@Nonnull EXFrameOptionType eXFrameOptionType, @Nullable ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)eXFrameOptionType, (String)"Type");
        if (eXFrameOptionType.isURLRequired()) {
            ValueEnforcer.notNull((Object)iSimpleURL, (String)"Domain");
        }
        this.m_sHeaderValue = eXFrameOptionType.isURLRequired() ? eXFrameOptionType.getID() + " " + iSimpleURL.getAsStringWithEncodedParameters() : eXFrameOptionType.getID();
    }

    @Override
    @Nonnull
    public EContinue beforeRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod) {
        httpServletResponse.addHeader("X-Frame-Options", this.m_sHeaderValue);
        return EContinue.CONTINUE;
    }
}

