/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.reflect.reflectCheck;

import com.holmos.reflect.reflectCheck.difference.HolmosClassDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosCollectionDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosCollectionIgnoreOrderDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosMapDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosObjectDifference;
import java.util.IdentityHashMap;
import java.util.Map;

public class HolmosMatchingScoreCalculator {
    private int CLASS_NOT_EQUAL = 10;
    private int SIMPLE_NOT_EQUAL = 1;
    protected HolmosMatchingScoreVisitor matchingScoreVisitor = new HolmosMatchingScoreVisitor();
    protected Map<HolmosDifference, Integer> matchingScores = new IdentityHashMap<HolmosDifference, Integer>();

    public int calculateMatchingScore(HolmosDifference difference) {
        if (difference == null) {
            return 0;
        }
        Integer matchingScore = this.matchingScores.get(difference);
        if (matchingScore == null) {
            matchingScore = this.matchingScoreVisitor.visit(difference, null);
            this.matchingScores.put(difference, matchingScore);
        }
        return matchingScore;
    }

    protected int getMatchingScore(HolmosDifference difference) {
        Object leftValue = difference.getLeftValue();
        Object rightValue = difference.getRightValue();
        if (leftValue != null && rightValue != null && !leftValue.getClass().equals(rightValue.getClass())) {
            return this.CLASS_NOT_EQUAL;
        }
        return this.SIMPLE_NOT_EQUAL;
    }

    protected int getMatchingScore(HolmosClassDifference difference) {
        Class<?> leftClass = difference.getLeftClass();
        Class<?> rightClass = difference.getRightClass();
        if (leftClass != null && rightClass != null && !leftClass.equals(rightClass)) {
            return this.CLASS_NOT_EQUAL;
        }
        return this.SIMPLE_NOT_EQUAL;
    }

    protected int getMatchingScore(HolmosCollectionDifference difference) {
        return difference.getAllElementsDifferences().size();
    }

    protected int getMatchingScore(HolmosMapDifference difference) {
        return difference.getValueDifferences().size();
    }

    protected int getMatchingScore(HolmosCollectionIgnoreOrderDifference difference) {
        return difference.getBestMatchScore();
    }

    protected class HolmosMatchingScoreVisitor {
        protected HolmosMatchingScoreVisitor() {
        }

        public Integer visit(HolmosDifference difference, Integer argument) {
            return HolmosMatchingScoreCalculator.this.getMatchingScore(difference);
        }

        public Integer visit(HolmosObjectDifference objectDifference, Integer argument) {
            return HolmosMatchingScoreCalculator.this.getMatchingScore(objectDifference);
        }

        public Integer visit(HolmosClassDifference classDifference, Integer argument) {
            return HolmosMatchingScoreCalculator.this.getMatchingScore(classDifference);
        }

        public Integer visit(HolmosMapDifference mapDifference, Integer argument) {
            return HolmosMatchingScoreCalculator.this.getMatchingScore(mapDifference);
        }

        public Integer visit(HolmosCollectionDifference collectionDifference, Integer argument) {
            return HolmosMatchingScoreCalculator.this.getMatchingScore(collectionDifference);
        }

        public Integer visit(HolmosCollectionIgnoreOrderDifference collectionIgnoreOrderDifference, Integer argument) {
            return HolmosMatchingScoreCalculator.this.getMatchingScore(collectionIgnoreOrderDifference);
        }
    }
}

