/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.reflect.reflectCheck;

import com.holmos.reflect.reflectCheck.comparator.HolmosComparator;
import com.holmos.reflect.reflectCheck.difference.HolmosDifference;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class HolmosReflectionComparator {
    protected List<HolmosComparator> comparators;
    protected Map<Object, Map<Object, HolmosDifference>> firstDifferenceCachedResults = new IdentityHashMap<Object, Map<Object, HolmosDifference>>();
    protected Map<Object, Map<Object, HolmosDifference>> allDifferencesCachedResults = new IdentityHashMap<Object, Map<Object, HolmosDifference>>();

    public HolmosReflectionComparator(List<HolmosComparator> comparators) {
        this.comparators = comparators;
    }

    public boolean isEqual(Object left, Object right) {
        HolmosDifference difference = this.getDifference(left, right, true);
        return difference == null;
    }

    public HolmosDifference getDifference(Object left, Object right) {
        return this.getDifference(left, right, false);
    }

    public HolmosDifference getDifference(Object left, Object right, boolean onlyFirstDifference) {
        Map<Object, HolmosDifference> cachedResult = this.getCachedDifference(left, onlyFirstDifference);
        if (cachedResult != null) {
            if (cachedResult.containsKey(right)) {
                return cachedResult.get(right);
            }
        } else {
            cachedResult = new IdentityHashMap<Object, HolmosDifference>();
            this.saveResultInCache(left, cachedResult, onlyFirstDifference);
        }
        cachedResult.put(right, null);
        boolean compared = false;
        HolmosDifference result = null;
        for (HolmosComparator comparator : this.comparators) {
            if (!comparator.canCompare(left, right)) continue;
            result = comparator.compare(left, right, onlyFirstDifference, this);
            compared = true;
            break;
        }
        cachedResult.put(right, result);
        return result;
    }

    protected void saveResultInCache(Object left, Map<Object, HolmosDifference> cachedResult, boolean onlyFirstDifference) {
        if (onlyFirstDifference) {
            this.firstDifferenceCachedResults.put(left, cachedResult);
        } else {
            this.allDifferencesCachedResults.put(left, cachedResult);
        }
    }

    protected Map<Object, HolmosDifference> getCachedDifference(Object left, boolean onlyFirstDifference) {
        if (onlyFirstDifference) {
            return this.firstDifferenceCachedResults.get(left);
        }
        return this.allDifferencesCachedResults.get(left);
    }
}

